/*
 * Decompiled with CFR 0.152.
 */
package proguard.util.kotlin;

import proguard.AppView;
import proguard.classfile.Clazz;
import proguard.classfile.io.kotlin.KotlinMetadataWriter;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMetadataVersion;
import proguard.classfile.kotlin.UnsupportedKotlinMetadata;
import proguard.classfile.kotlin.visitor.KotlinMetadataRemover;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.util.kotlin.KotlinMetadataInitializer;
import proguard.pass.Pass;

public class KotlinUnsupportedVersionChecker
implements Pass {
    @Override
    public void execute(AppView appView) throws Exception {
        ReferencedKotlinMetadataVisitor unsupportedMetadataChecker = new ReferencedKotlinMetadataVisitor(new MyUnsupportedKotlinMetadataChecker());
        appView.programClassPool.classesAccept(unsupportedMetadataChecker);
        appView.libraryClassPool.classesAccept(unsupportedMetadataChecker);
    }

    private static class MyUnsupportedKotlinMetadataChecker
    implements KotlinMetadataVisitor {
        private MyUnsupportedKotlinMetadataChecker() {
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitUnsupportedKotlinMetadata(Clazz clazz, UnsupportedKotlinMetadata kotlinMetadata) {
            if (!(kotlinMetadata.mv == null || kotlinMetadata.mv.length != 2 && kotlinMetadata.mv.length != 3 || KotlinMetadataInitializer.isSupportedMetadataVersion(new KotlinMetadataVersion(kotlinMetadata.mv)))) {
                throw new RuntimeException("Unsupported Kotlin metadata version " + new KotlinMetadataVersion(kotlinMetadata.mv) + " found on class '" + clazz.getName() + "'." + System.lineSeparator() + "Kotlin versions up to " + KotlinMetadataWriter.LATEST_STABLE_SUPPORTED + " are supported.");
            }
            clazz.accept(new KotlinMetadataRemover());
        }
    }
}

