/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.Signature;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.MethodCollector;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0007J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\u0013"}, d2={"Lproguard/util/DebugUtil;", "", "()V", "asString", "", "cfa", "Lproguard/analysis/cpa/jvm/cfa/JvmCfa;", "signature", "Lproguard/classfile/MethodSignature;", "verbose", "", "classPool", "Lproguard/classfile/ClassPool;", "className", "clazz", "Lproguard/classfile/Clazz;", "method", "Lproguard/classfile/Method;", "getMethodFqnList", "proguard-core"})
@SourceDebugExtension(value={"SMAP\nDebugUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugUtil.kt\nproguard/util/DebugUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class DebugUtil {
    @NotNull
    public static final DebugUtil INSTANCE = new DebugUtil();

    private DebugUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String asString(@NotNull Clazz clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        clazz.accept(new ClassPrinter(pw));
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sw.toString()");
        return string;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String asString(@NotNull Clazz clazz, @NotNull Method method, boolean verbose) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(method, "method");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (verbose) {
            method.accept(clazz, new ClassPrinter(pw));
        } else {
            method.accept(clazz, new AllAttributeVisitor(new AttributeNameFilter("Code", (AttributeVisitor)new AllInstructionVisitor(new ClassPrinter(pw)))));
        }
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sw.toString()");
        return string;
    }

    public static /* synthetic */ String asString$default(Clazz clazz, Method method, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return DebugUtil.asString(clazz, method, bl);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String asString(@NotNull ClassPool classPool, @NotNull MethodSignature signature, boolean verbose) {
        Intrinsics.checkNotNullParameter(classPool, "classPool");
        Intrinsics.checkNotNullParameter(signature, "signature");
        Clazz clazz = classPool.getClass(signature.getClassName());
        if (!(clazz != null)) {
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append("Class ");
            Clazz clazz2 = clazz;
            Intrinsics.checkNotNull(clazz2);
            String string = stringBuilder.append(clazz2.getName()).append(" not found in class pool").toString();
            throw new IllegalStateException(string.toString());
        }
        Method method = clazz.findMethod(signature.method, String.valueOf(signature.descriptor));
        if (!(method != null)) {
            boolean bl = false;
            String string = "Method " + signature + " not found in class " + clazz.getName();
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue(clazz, "clazz");
        Intrinsics.checkNotNullExpressionValue(method, "method");
        return DebugUtil.asString(clazz, method, verbose);
    }

    public static /* synthetic */ String asString$default(ClassPool classPool, MethodSignature methodSignature, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return DebugUtil.asString(classPool, methodSignature, bl);
    }

    @JvmStatic
    @NotNull
    public static final String asString(@NotNull ClassPool classPool, @NotNull String className) {
        Intrinsics.checkNotNullParameter(classPool, "classPool");
        Intrinsics.checkNotNullParameter(className, "className");
        Clazz clazz = classPool.getClass(className);
        if (!(clazz != null)) {
            boolean bl = false;
            String string = "Class " + className + " not found in class pool";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue(clazz, "clazz");
        return DebugUtil.asString(clazz);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String asString(@NotNull JvmCfa cfa, @NotNull MethodSignature signature, boolean verbose) {
        Intrinsics.checkNotNullParameter(cfa, "cfa");
        Intrinsics.checkNotNullParameter(signature, "signature");
        JvmCfaNode jvmCfaNode = (JvmCfaNode)cfa.getFunctionEntryNode((Signature)signature);
        if (jvmCfaNode == null) {
            throw new IllegalStateException("Method " + signature + " not found in CFA");
        }
        JvmCfaNode methodNode = jvmCfaNode;
        Clazz clazz = methodNode.getClazz();
        if (!(clazz instanceof ProgramClass)) {
            boolean bl = false;
            String string = "Class " + clazz.getName() + " is not a program class";
            throw new IllegalStateException(string.toString());
        }
        Method method = clazz.findMethod(signature.method, String.valueOf(signature.descriptor));
        if (!(method instanceof ProgramMethod)) {
            boolean bl = false;
            String string = "Method " + signature + " not found in class " + clazz.getName();
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue(clazz, "clazz");
        Intrinsics.checkNotNullExpressionValue(method, "method");
        return DebugUtil.asString(clazz, method, verbose);
    }

    public static /* synthetic */ String asString$default(JvmCfa jvmCfa, MethodSignature methodSignature, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return DebugUtil.asString(jvmCfa, methodSignature, bl);
    }

    @JvmStatic
    @NotNull
    public static final String getMethodFqnList(@NotNull ClassPool classPool, @Nullable String className) {
        Intrinsics.checkNotNullParameter(classPool, "classPool");
        Clazz clazz = classPool.getClass(className);
        if (clazz == null) {
            throw new IllegalStateException("Class not found");
        }
        Clazz clazz2 = clazz;
        Set methods = new LinkedHashSet();
        MethodCollector collector = new MethodCollector(methods);
        clazz2.methodsAccept(collector);
        return CollectionsKt.joinToString$default(methods, ",\n", null, null, 0, null, new Function1<Method, CharSequence>(clazz2){
            final /* synthetic */ Clazz $clazz;
            {
                this.$clazz = $clazz;
                super(1);
            }

            public final CharSequence invoke(Method it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return '\"' + new MethodSignature(this.$clazz, it).getFqn() + '\"';
            }
        }, 30, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String asString(@NotNull Clazz clazz, @NotNull Method method) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(method, "method");
        return DebugUtil.asString$default(clazz, method, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String asString(@NotNull ClassPool classPool, @NotNull MethodSignature signature) {
        Intrinsics.checkNotNullParameter(classPool, "classPool");
        Intrinsics.checkNotNullParameter(signature, "signature");
        return DebugUtil.asString$default(classPool, signature, false, 4, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String asString(@NotNull JvmCfa cfa, @NotNull MethodSignature signature) {
        Intrinsics.checkNotNullParameter(cfa, "cfa");
        Intrinsics.checkNotNullParameter(signature, "signature");
        return DebugUtil.asString$default(cfa, signature, false, 4, null);
    }
}

