/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ClassBuilder;
import proguard.classfile.editor.CompactCodeAttributeComposer;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberAccessFlagCleaner;
import proguard.classfile.visitor.MemberAccessSetter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.io.ExtraDataEntryNameMap;
import proguard.optimize.gson.FieldSignatureCollector;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.InlineDeserializer;
import proguard.optimize.gson.InlineDeserializers;
import proguard.optimize.gson.OptimizedClassConstants;
import proguard.optimize.gson.OptimizedJsonInfo;
import proguard.optimize.gson.TypeTokenClassBuilder;
import proguard.optimize.info.ProgramMemberOptimizationInfoSetter;

public class GsonDeserializationOptimizer
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private static final Logger logger = LogManager.getLogger(GsonDeserializationOptimizer.class);
    private static final int IS_NULL_VARIABLE_INDEX = ClassUtil.internalMethodParameterSize("(Lcom/google/gson/Gson;Lcom/google/gson/stream/JsonReader;I)V", false);
    private static final Map<String, InlineDeserializer> inlineDeserializers = new HashMap<String, InlineDeserializer>();
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final GsonRuntimeSettings gsonRuntimeSettings;
    private final OptimizedJsonInfo deserializationInfo;
    private final boolean supportExposeAnnotation;
    private final boolean optimizeConservatively;
    private final ExtraDataEntryNameMap extraDataEntryNameMap;
    private OptimizedJsonInfo.ClassJsonInfo classDeserializationInfo;
    private Map<String, String[]> javaToJsonFieldNames;
    private Map<String, CompactCodeAttributeComposer.Label> caseLabelByJavaFieldName;

    public GsonDeserializationOptimizer(ClassPool programClassPool, ClassPool libraryClassPool, GsonRuntimeSettings gsonRuntimeSettings, OptimizedJsonInfo deserializationInfo, boolean optimizeConservatively, ExtraDataEntryNameMap extraDataEntryNameMap) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.gsonRuntimeSettings = gsonRuntimeSettings;
        this.deserializationInfo = deserializationInfo;
        this.supportExposeAnnotation = gsonRuntimeSettings.excludeFieldsWithoutExposeAnnotation;
        this.optimizeConservatively = optimizeConservatively;
        this.extraDataEntryNameMap = extraDataEntryNameMap;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2accessFlags &= 0xFFFFFFFD;
        programClass.u2accessFlags |= 1;
        MemberCounter constructorCounter = new MemberCounter();
        programClass.methodsAccept(new MemberNameFilter("<init>", (MemberVisitor)new MemberDescriptorFilter("()V", (MemberVisitor)new MultiMemberVisitor(new MemberAccessSetter(1), constructorCounter))));
        ClassBuilder classBuilder = new ClassBuilder(programClass);
        if (constructorCounter.getCount() == 0) {
            this.addDefaultConstructor(programClass, classBuilder);
        }
        int classIndex = this.deserializationInfo.classIndices.get(programClass.getName());
        this.addFromJsonMethod(programClass, classBuilder, classIndex);
        this.addFromJsonFieldMethod(programClass, classBuilder, classIndex);
        programClass.accept(new ClassReferenceInitializer(this.programClassPool, this.libraryClassPool));
        programClass.accept(new MethodLinker());
    }

    private void addDefaultConstructor(ProgramClass programClass, ClassBuilder classBuilder) {
        logger.debug("GsonDeserializationOptimizer: adding default constructor to {}", (Object)programClass.getName());
        classBuilder.addMethod(4097, "<init>", "()V", 10, ____ -> ____.aload_0().invokespecial(programClass.getSuperName(), "<init>", "()V").return_(), new ProgramMemberOptimizationInfoSetter(false, this.optimizeConservatively));
    }

    private void addFromJsonMethod(ProgramClass programClass, ClassBuilder classBuilder, int classIndex) {
        String methodNameFromJson = "fromJson$" + classIndex;
        logger.debug("GsonDeserializationOptimizer: adding {} method to {}", (Object)methodNameFromJson, (Object)programClass.getName());
        classBuilder.addMethod(4097, methodNameFromJson, OptimizedClassConstants.METHOD_TYPE_FROM_JSON, 1000, ____ -> {
            ____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "beginObject", "()V");
            int nextFieldIndexLocalIndex = 4;
            CompactCodeAttributeComposer.Label startWhile = ____.createLabel();
            CompactCodeAttributeComposer.Label endJsonObject = ____.createLabel();
            ____.label(startWhile).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "hasNext", "()Z").ifeq(endJsonObject);
            ____.aload(3).aload(2).invokeinterface("proguard/optimize/gson/_OptimizedJsonReader", "b", "(Lcom/google/gson/stream/JsonReader;)I").istore(nextFieldIndexLocalIndex);
            this.classDeserializationInfo = this.deserializationInfo.classJsonInfos.get(programClass.getName());
            this.javaToJsonFieldNames = this.classDeserializationInfo.javaToJsonFieldNames;
            String methodNameFromJsonField = "fromJsonField$" + classIndex;
            ____.aload(0).aload(1).aload(2).iload(nextFieldIndexLocalIndex).invokevirtual(programClass.getName(), methodNameFromJsonField, "(Lcom/google/gson/Gson;Lcom/google/gson/stream/JsonReader;I)V");
            ____.goto_(startWhile);
            ____.label(endJsonObject).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "endObject", "()V").return_();
        }, new ProgramMemberOptimizationInfoSetter(false, this.optimizeConservatively));
    }

    private void addFromJsonFieldMethod(ProgramClass programClass, ClassBuilder classBuilder, int classIndex) {
        String methodNameFromJsonField = "fromJsonField$" + classIndex;
        logger.debug("GsonDeserializationOptimizer: adding {} method to {}", (Object)methodNameFromJsonField, (Object)programClass.getName());
        classBuilder.addMethod(4100, methodNameFromJsonField, "(Lcom/google/gson/Gson;Lcom/google/gson/stream/JsonReader;I)V", 1000, ____ -> {
            CompactCodeAttributeComposer.Label endSwitch = ____.createLabel();
            if (this.javaToJsonFieldNames.size() > 0) {
                CompactCodeAttributeComposer.Label tokenNotNull = ____.createLabel();
                CompactCodeAttributeComposer.Label assignIsNull = ____.createLabel();
                ____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "peek", "()Lcom/google/gson/stream/JsonToken;").getstatic("com/google/gson/stream/JsonToken", "NULL", "Lcom/google/gson/stream/JsonToken;");
                ____.ifacmpeq(tokenNotNull).iconst_1().goto_(assignIsNull).label(tokenNotNull).iconst_0().label(assignIsNull).istore(IS_NULL_VARIABLE_INDEX);
                this.generateSwitchTables(____, endSwitch);
            }
            if (programClass.getSuperClass() != null) {
                if (!programClass.getSuperClass().getName().equals("java/lang/Object")) {
                    Integer superClassIndex = this.deserializationInfo.classIndices.get(programClass.getSuperClass().getName());
                    String superMethodNameFromJsonField = "fromJsonField$" + superClassIndex;
                    ____.aload(0).aload(1).aload(2).iload(3).invokevirtual(programClass.getSuperClass().getName(), superMethodNameFromJsonField, "(Lcom/google/gson/Gson;Lcom/google/gson/stream/JsonReader;I)V");
                } else {
                    ____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "skipValue", "()V");
                }
            } else {
                throw new RuntimeException("Cannot find super class of " + programClass.getName() + " for Gson optimization. Please check your configuration includes all the expected library jars.");
            }
            ____.label(endSwitch).return_();
        }, new ProgramMemberOptimizationInfoSetter(false, this.optimizeConservatively));
    }

    private void generateSwitchTables(CompactCodeAttributeComposer ____, CompactCodeAttributeComposer.Label endSwitch) {
        Set<String> exposedJavaFieldNames = this.classDeserializationInfo.exposedJavaFieldNames;
        Set<String> exposedOrAllJavaFieldNames = this.supportExposeAnnotation ? exposedJavaFieldNames : this.javaToJsonFieldNames.keySet();
        this.generateSwitchTable(____, endSwitch, this.javaToJsonFieldNames, exposedOrAllJavaFieldNames);
        if (this.supportExposeAnnotation) {
            CompactCodeAttributeComposer.Label nonExposedCasesEnd = ____.createLabel();
            ____.aload(1).getfield("com/google/gson/Gson", "excluder", "Lcom/google/gson/internal/Excluder;").getfield("com/google/gson/internal/Excluder", "requireExpose", "Z").ifne(nonExposedCasesEnd);
            HashSet<String> nonExposedJavaFieldNames = new HashSet<String>();
            for (String javaFieldName : this.javaToJsonFieldNames.keySet()) {
                if (exposedJavaFieldNames.contains(javaFieldName)) continue;
                nonExposedJavaFieldNames.add(javaFieldName);
            }
            this.generateSwitchTable(____, endSwitch, this.javaToJsonFieldNames, nonExposedJavaFieldNames);
            ____.label(nonExposedCasesEnd);
        }
    }

    private void generateSwitchTable(CompactCodeAttributeComposer ____, CompactCodeAttributeComposer.Label endSwitch, Map<String, String[]> javaToJsonFieldNames, Set<String> javaFieldNamesToProcess) {
        ArrayList<FromJsonFieldCase> fromJsonFieldCases = new ArrayList<FromJsonFieldCase>();
        for (Map.Entry<String, String[]> javaToJsonFieldNameEntry : javaToJsonFieldNames.entrySet()) {
            if (!javaFieldNamesToProcess.contains(javaToJsonFieldNameEntry.getKey())) continue;
            String[] jsonFieldNames = javaToJsonFieldNameEntry.getValue();
            CompactCodeAttributeComposer.Label caseLabel = ____.createLabel();
            for (String jsonFieldName : jsonFieldNames) {
                fromJsonFieldCases.add(new FromJsonFieldCase(javaToJsonFieldNameEntry.getKey(), caseLabel, this.deserializationInfo.jsonFieldIndices.get(jsonFieldName)));
            }
        }
        Collections.sort(fromJsonFieldCases);
        fromJsonFieldCases.removeIf(fromJsonFieldCase -> {
            Field field = ____.getTargetClass().findField(((FromJsonFieldCase)fromJsonFieldCase).javaFieldName, null);
            return field == null || (field.getAccessFlags() & 0x1008) != 0;
        });
        int[] cases = new int[fromJsonFieldCases.size()];
        CompactCodeAttributeComposer.Label[] jumpOffsets = new CompactCodeAttributeComposer.Label[fromJsonFieldCases.size()];
        this.caseLabelByJavaFieldName = new HashMap<String, CompactCodeAttributeComposer.Label>();
        for (int caseIndex = 0; caseIndex < fromJsonFieldCases.size(); ++caseIndex) {
            FromJsonFieldCase fromJsonFieldCase2 = (FromJsonFieldCase)fromJsonFieldCases.get(caseIndex);
            cases[caseIndex] = fromJsonFieldCase2.fieldIndex;
            jumpOffsets[caseIndex] = fromJsonFieldCase2.label;
            this.caseLabelByJavaFieldName.put(fromJsonFieldCase2.javaFieldName, fromJsonFieldCase2.label);
        }
        CompactCodeAttributeComposer.Label defaultCase = ____.createLabel();
        ____.iload(3).lookupswitch(defaultCase, cases, jumpOffsets);
        ____.getTargetClass().fieldsAccept(new MemberAccessFilter(0, 4104, new FromJsonFieldDeserializationCodeAdder(____, endSwitch)));
        ____.label(defaultCase);
    }

    static {
        inlineDeserializers.put("B", new InlineDeserializers.InlinePrimitiveIntegerDeserializer(Byte.TYPE));
        inlineDeserializers.put("S", new InlineDeserializers.InlinePrimitiveIntegerDeserializer(Short.TYPE));
        inlineDeserializers.put("I", new InlineDeserializers.InlinePrimitiveIntegerDeserializer());
        inlineDeserializers.put("Ljava/lang/String;", new InlineDeserializers.InlineStringDeserializer());
    }

    private static class FromJsonFieldCase
    implements Comparable<FromJsonFieldCase> {
        private String javaFieldName;
        private CompactCodeAttributeComposer.Label label;
        private int fieldIndex;

        public FromJsonFieldCase(String javaFieldName, CompactCodeAttributeComposer.Label label, int fieldIndex) {
            this.javaFieldName = javaFieldName;
            this.label = label;
            this.fieldIndex = fieldIndex;
        }

        @Override
        public int compareTo(FromJsonFieldCase fromJsonFieldCase) {
            return this.fieldIndex - fromJsonFieldCase.fieldIndex;
        }
    }

    private class FromJsonFieldDeserializationCodeAdder
    implements MemberVisitor {
        private final CompactCodeAttributeComposer ____;
        private final CompactCodeAttributeComposer.Label endSwitch;

        public FromJsonFieldDeserializationCodeAdder(CompactCodeAttributeComposer ____, CompactCodeAttributeComposer.Label endSwitch) {
            this.____ = ____;
            this.endSwitch = endSwitch;
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            CompactCodeAttributeComposer.Label fromJsonFieldCaseLabel = (CompactCodeAttributeComposer.Label)GsonDeserializationOptimizer.this.caseLabelByJavaFieldName.get(programField.getName(programClass));
            if (fromJsonFieldCaseLabel != null) {
                programField.accept(programClass, (MemberVisitor)new MemberAccessFlagCleaner(16));
                CompactCodeAttributeComposer.Label isNull = this.____.createLabel();
                this.____.label(fromJsonFieldCaseLabel).iload(IS_NULL_VARIABLE_INDEX).ifeq(isNull);
                String fieldDescriptor = programField.getDescriptor(programClass);
                FieldSignatureCollector signatureAttributeCollector = new FieldSignatureCollector();
                programField.attributesAccept(programClass, signatureAttributeCollector);
                InlineDeserializer inlineDeserializer = (InlineDeserializer)inlineDeserializers.get(fieldDescriptor);
                if (!((GsonDeserializationOptimizer)GsonDeserializationOptimizer.this).gsonRuntimeSettings.registerTypeAdapterFactory && inlineDeserializer != null && inlineDeserializer.canDeserialize(GsonDeserializationOptimizer.this.gsonRuntimeSettings)) {
                    inlineDeserializer.deserialize(programClass, programField, this.____, GsonDeserializationOptimizer.this.gsonRuntimeSettings);
                } else {
                    String fieldTypeName;
                    String fieldClassName;
                    if (ClassUtil.isInternalPrimitiveType(fieldDescriptor)) {
                        fieldTypeName = fieldClassName = ClassUtil.internalNumericClassNameFromPrimitiveType(fieldDescriptor.charAt(0));
                    } else {
                        fieldClassName = ClassUtil.internalClassNameFromClassType(fieldDescriptor);
                        fieldTypeName = ClassUtil.internalClassTypeFromType(fieldDescriptor);
                    }
                    String typeTokenClassName = null;
                    if (signatureAttributeCollector.getFieldSignature() != null) {
                        ProgramClass typeTokenClass = new TypeTokenClassBuilder(programClass, programField, signatureAttributeCollector.getFieldSignature()).build(GsonDeserializationOptimizer.this.programClassPool);
                        GsonDeserializationOptimizer.this.programClassPool.addClass(typeTokenClass);
                        typeTokenClass.accept(new ClassReferenceInitializer(GsonDeserializationOptimizer.this.programClassPool, GsonDeserializationOptimizer.this.libraryClassPool));
                        typeTokenClassName = typeTokenClass.getName();
                        GsonDeserializationOptimizer.this.extraDataEntryNameMap.addExtraClassToClass(programClass.getName(), typeTokenClassName);
                    }
                    if (typeTokenClassName == null) {
                        this.____.aload(0).aload(1).ldc(fieldTypeName, GsonDeserializationOptimizer.this.programClassPool.getClass(fieldClassName)).invokevirtual("com/google/gson/Gson", "getAdapter", "(Ljava/lang/Class;)Lcom/google/gson/TypeAdapter;");
                    } else {
                        this.____.aload(0).aload(1).new_(typeTokenClassName).dup().invokespecial(typeTokenClassName, "<init>", "()V").invokevirtual("com/google/gson/Gson", "getAdapter", "(Lcom/google/gson/reflect/TypeToken;)Lcom/google/gson/TypeAdapter;");
                    }
                    this.____.aload(2).invokevirtual("com/google/gson/TypeAdapter", "read", "(Lcom/google/gson/stream/JsonReader;)Ljava/lang/Object;").checkcast(fieldTypeName, GsonDeserializationOptimizer.this.programClassPool.getClass(fieldClassName));
                    switch (fieldDescriptor.charAt(0)) {
                        case 'Z': {
                            this.____.invokevirtual("java/lang/Boolean", "booleanValue", "()Z");
                            break;
                        }
                        case 'B': {
                            this.____.invokevirtual("java/lang/Byte", "byteValue", "()B");
                            break;
                        }
                        case 'C': {
                            this.____.invokevirtual("java/lang/Character", "charValue", "()C");
                            break;
                        }
                        case 'S': {
                            this.____.invokevirtual("java/lang/Short", "shortValue", "()S");
                            break;
                        }
                        case 'I': {
                            this.____.invokevirtual("java/lang/Integer", "intValue", "()I");
                            break;
                        }
                        case 'J': {
                            this.____.invokevirtual("java/lang/Long", "longValue", "()J");
                            break;
                        }
                        case 'F': {
                            this.____.invokevirtual("java/lang/Float", "floatValue", "()F");
                            break;
                        }
                        case 'D': {
                            this.____.invokevirtual("java/lang/Double", "doubleValue", "()D");
                        }
                    }
                    this.____.putfield(programClass, programField);
                }
                this.____.goto_(this.endSwitch);
                this.____.label(isNull);
                if (!ClassUtil.isInternalPrimitiveType(fieldDescriptor)) {
                    this.____.aload(0).aconst_null().putfield(programClass, programField);
                }
                this.____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "nextNull", "()V").goto_(this.endSwitch);
            }
        }
    }
}

