/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate.kotlin;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class KotlinCompanionEqualizer
implements KotlinMetadataVisitor {
    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        if (kotlinClassKindMetadata.companionObjectName != null) {
            String newCompanionClassName = ClassObfuscator.newClassName(kotlinClassKindMetadata.referencedCompanionClass);
            if (newCompanionClassName == null) {
                return;
            }
            if (newCompanionClassName.contains("$")) {
                if ((kotlinClassKindMetadata.referencedCompanionField.getProcessingFlags() & 0x400000) != 0) {
                    ClassObfuscator.setNewClassName(kotlinClassKindMetadata.referencedCompanionClass, ClassObfuscator.newClassName(kotlinClassKindMetadata.referencedClass) + "$" + kotlinClassKindMetadata.companionObjectName);
                } else {
                    String newCompanionSimpleClassName = ClassUtil.internalSimpleClassName(newCompanionClassName);
                    ConflictingFieldChecker conflictingFieldChecker = new ConflictingFieldChecker(newCompanionSimpleClassName);
                    clazz.hierarchyAccept(false, true, true, false, new AllFieldVisitor(conflictingFieldChecker));
                    if (conflictingFieldChecker.isConflicting) {
                        newCompanionClassName = newCompanionClassName + "_";
                        ClassObfuscator.setNewClassName(kotlinClassKindMetadata.referencedCompanionClass, newCompanionClassName);
                    }
                    MemberObfuscator.setFixedNewMemberName(kotlinClassKindMetadata.referencedCompanionField, ClassUtil.internalSimpleClassName(newCompanionClassName));
                }
            }
        }
    }

    private static class ConflictingFieldChecker
    implements MemberVisitor {
        public boolean isConflicting = false;
        private String newCompanionSimpleClassName;

        public ConflictingFieldChecker(String newCompanionSimpleClassName) {
            this.newCompanionSimpleClassName = newCompanionSimpleClassName;
        }

        @Override
        public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        }

        @Override
        public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
            this.isConflicting |= this.newCompanionSimpleClassName.equals(MemberObfuscator.newMemberName(programMember));
        }
    }
}

