/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AppView;
import proguard.Configuration;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AllBootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.AllInnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.attribute.visitor.NonEmptyAttributeFilter;
import proguard.classfile.attribute.visitor.RequiredAttributeFilter;
import proguard.classfile.constant.visitor.AllBootstrapMethodArgumentVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.AccessFixer;
import proguard.classfile.editor.BridgeMethodFixer;
import proguard.classfile.editor.ClassReferenceFixer;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InnerClassesAccessFixer;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.kotlin.visitor.AllConstructorVisitor;
import proguard.classfile.kotlin.visitor.AllFunctionVisitor;
import proguard.classfile.kotlin.visitor.AllPropertyVisitor;
import proguard.classfile.kotlin.visitor.AllTypeVisitor;
import proguard.classfile.kotlin.visitor.AllValueParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinClassToDefaultImplsClassVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionToDefaultMethodVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataToClazzVisitor;
import proguard.classfile.kotlin.visitor.MethodToKotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.MultiKotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.filter.KotlinClassKindFilter;
import proguard.classfile.kotlin.visitor.filter.KotlinSyntheticClassKindFilter;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.WarningLogger;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.BottomClassFilter;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.DynamicReturnedClassVisitor;
import proguard.classfile.visitor.FunctionalInterfaceFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberProcessingFlagFilter;
import proguard.classfile.visitor.MethodFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.ProgramClassFilter;
import proguard.classfile.visitor.ProgramMemberFilter;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.fixer.kotlin.KotlinAnnotationFlagFixer;
import proguard.obfuscate.AttributeShrinker;
import proguard.obfuscate.AttributeUsageMarker;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.ClassRenamer;
import proguard.obfuscate.DictionaryNameFactory;
import proguard.obfuscate.MapCleaner;
import proguard.obfuscate.MappingKeeper;
import proguard.obfuscate.MappingPrinter;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MappingReader;
import proguard.obfuscate.MemberNameCollector;
import proguard.obfuscate.MemberNameConflictFixer;
import proguard.obfuscate.MemberObfuscator;
import proguard.obfuscate.MemberSpecialNameFilter;
import proguard.obfuscate.MultiMappingProcessor;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.NameMarker;
import proguard.obfuscate.NewMemberNameFilter;
import proguard.obfuscate.OriginalClassNameFilter;
import proguard.obfuscate.ParameterNameMarker;
import proguard.obfuscate.RenamedFlagSetter;
import proguard.obfuscate.SimpleNameFactory;
import proguard.obfuscate.SourceFileRenamer;
import proguard.obfuscate.SpecialNameFactory;
import proguard.obfuscate.kotlin.KotlinAliasNameObfuscator;
import proguard.obfuscate.kotlin.KotlinAliasReferenceFixer;
import proguard.obfuscate.kotlin.KotlinCallableReferenceFixer;
import proguard.obfuscate.kotlin.KotlinCompanionEqualizer;
import proguard.obfuscate.kotlin.KotlinDefaultImplsMethodNameEqualizer;
import proguard.obfuscate.kotlin.KotlinDefaultMethodNameEqualizer;
import proguard.obfuscate.kotlin.KotlinIntrinsicsReplacementSequences;
import proguard.obfuscate.kotlin.KotlinModuleNameObfuscator;
import proguard.obfuscate.kotlin.KotlinMultiFileFacadeFixer;
import proguard.obfuscate.kotlin.KotlinObjectFixer;
import proguard.obfuscate.kotlin.KotlinPropertyNameObfuscator;
import proguard.obfuscate.kotlin.KotlinPropertyRenamer;
import proguard.obfuscate.kotlin.KotlinSourceDebugExtensionAttributeObfuscator;
import proguard.obfuscate.kotlin.KotlinSyntheticClassFixer;
import proguard.obfuscate.kotlin.KotlinSyntheticToStringObfuscator;
import proguard.obfuscate.kotlin.KotlinUnsupportedExceptionReplacementSequences;
import proguard.obfuscate.kotlin.KotlinValueParameterNameShrinker;
import proguard.obfuscate.kotlin.KotlinValueParameterUsageMarker;
import proguard.obfuscate.util.InstructionSequenceObfuscator;
import proguard.pass.Pass;
import proguard.resources.file.visitor.ResourceFileProcessingFlagFilter;
import proguard.util.PrintWriterUtil;

public class Obfuscator
implements Pass {
    private static final Logger logger = LogManager.getLogger(Obfuscator.class);
    private final Configuration configuration;

    public Obfuscator(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(AppView appView) throws IOException {
        logger.info("Obfuscating...");
        PrintWriter out = new PrintWriter(System.out, true);
        BottomClassFilter memberInfoLinker = new BottomClassFilter(new MethodLinker());
        appView.programClassPool.classesAccept(memberInfoLinker);
        appView.libraryClassPool.classesAccept(memberInfoLinker);
        if (this.configuration.useUniqueClassMemberNames) {
            appView.programClassPool.classesAccept(new AllMemberVisitor(new MethodLinker()));
        }
        NameMarker nameMarker = new NameMarker();
        appView.libraryClassPool.classesAccept(nameMarker);
        appView.libraryClassPool.classesAccept(new AllMemberVisitor(nameMarker));
        appView.programClassPool.classesAccept(new MultiClassVisitor(new ClassProcessingFlagFilter(0x400000, 0, nameMarker), new AllMemberVisitor(new MemberProcessingFlagFilter(0x400000, 0, nameMarker))));
        appView.programClassPool.classesAccept(new ClassVersionFilter(0x330000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AllBootstrapMethodInfoVisitor(new AllBootstrapMethodArgumentVisitor(new ConstantTagFilter(7, (ConstantVisitor)new ReferencedClassVisitor(new FunctionalInterfaceFilter(new ClassHierarchyTraveler(true, false, true, false, new AllMethodVisitor(new MemberAccessFilter(1024, 0, nameMarker))))))))))));
        appView.programClassPool.classesAccept(new ClassVersionFilter(0x330000, new AllConstantVisitor(new DynamicReturnedClassVisitor(new FunctionalInterfaceFilter(new ClassHierarchyTraveler(true, false, true, false, new AllMethodVisitor(new MemberAccessFilter(1024, 0, nameMarker))))))));
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept(new ClassProcessingFlagFilter(0x400000, 0, new ReferencedKotlinMetadataVisitor(new KotlinClassToDefaultImplsClassVisitor(nameMarker))));
        }
        NonEmptyAttributeFilter attributeUsageMarker = new NonEmptyAttributeFilter(new AttributeUsageMarker());
        AttributeNameFilter optionalAttributeUsageMarker = this.configuration.keepAttributes == null ? null : new AttributeNameFilter(this.configuration.keepAttributes, (AttributeVisitor)attributeUsageMarker);
        appView.programClassPool.classesAccept(new AllAttributeVisitor(true, new RequiredAttributeFilter(attributeUsageMarker, optionalAttributeUsageMarker)));
        if (this.configuration.keepParameterNames) {
            appView.programClassPool.classesAccept(new AllMethodVisitor(new NewMemberNameFilter(new AllAttributeVisitor(true, new ParameterNameMarker(attributeUsageMarker)))));
            if (this.configuration.keepKotlinMetadata) {
                appView.programClassPool.classesAccept(new MultiClassVisitor(new ClassAccessFilter(512, 0, new AllMethodVisitor(new NewMemberNameFilter(new MethodToKotlinFunctionVisitor(new AllValueParameterVisitor(new KotlinValueParameterUsageMarker()))))), new ClassAccessFilter(512, 0, new ClassProcessingFlagFilter(0x400000, 0, new ReferencedKotlinMetadataVisitor(new KotlinClassKindFilter(metadata -> metadata.flags.isAnnotationClass, new AllConstructorVisitor(new AllValueParameterVisitor(new KotlinValueParameterUsageMarker())))))), new ReferencedKotlinMetadataVisitor(new KotlinValueParameterUsageMarker())));
            }
        }
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new KotlinValueParameterNameShrinker()));
            appView.programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new KotlinSyntheticClassKindFilter(KotlinSyntheticClassKindFilter::isLambda, new KotlinMetadataToClazzVisitor(new AllAttributeVisitor(new AttributeNameFilter("SourceDebugExtension", (AttributeVisitor)new MultiAttributeVisitor(attributeUsageMarker, new KotlinSourceDebugExtensionAttributeObfuscator())))))));
        }
        appView.programClassPool.classesAccept(new AttributeShrinker());
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new KotlinAnnotationFlagFixer()));
        }
        if (this.configuration.applyMapping != null) {
            logger.info("Applying mapping from [{}]...", (Object)PrintWriterUtil.fileName(this.configuration.applyMapping));
            WarningLogger warningPrinter = new WarningLogger(logger, this.configuration.warn);
            MappingReader reader = new MappingReader(this.configuration.applyMapping);
            MultiMappingProcessor keeper = new MultiMappingProcessor(new MappingProcessor[]{new MappingKeeper(appView.programClassPool, warningPrinter), new MappingKeeper(appView.libraryClassPool, null)});
            reader.pump(keeper);
            int warningCount = ((WarningPrinter)warningPrinter).getWarningCount();
            if (warningCount > 0) {
                logger.warn("Warning: there were {} kept classes and class members that were remapped anyway.", (Object)warningCount);
                logger.warn("         You should adapt your configuration or edit the mapping file.");
                if (!this.configuration.ignoreWarnings) {
                    logger.warn("         If you are sure this remapping won't hurt,");
                    logger.warn("         you could try your luck using the '-ignorewarnings' option.");
                }
                logger.warn("         (https://www.guardsquare.com/proguard/manual/troubleshooting#mappingconflict1)");
                if (!this.configuration.ignoreWarnings) {
                    throw new IOException("Please correct the above warnings first.");
                }
            }
        }
        DictionaryNameFactory classNameFactory = this.configuration.classObfuscationDictionary != null ? new DictionaryNameFactory(this.configuration.classObfuscationDictionary, null) : null;
        DictionaryNameFactory packageNameFactory = this.configuration.packageObfuscationDictionary != null ? new DictionaryNameFactory(this.configuration.packageObfuscationDictionary, null) : null;
        appView.programClassPool.classesAccept(new ClassObfuscator(appView.programClassPool, appView.libraryClassPool, classNameFactory, packageNameFactory, this.configuration.useMixedCaseClassNames, this.configuration.keepPackageNames, this.configuration.flattenPackageHierarchy, this.configuration.repackageClasses, this.configuration.allowAccessModification, this.configuration.keepKotlinMetadata));
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new KotlinCompanionEqualizer()));
        }
        NameFactory nameFactory = new SimpleNameFactory();
        if (this.configuration.obfuscationDictionary != null) {
            nameFactory = new DictionaryNameFactory(this.configuration.obfuscationDictionary, nameFactory);
        }
        WarningLogger warningPrinter = new WarningLogger(logger, this.configuration.warn);
        HashMap descriptorMap = new HashMap();
        if (this.configuration.useUniqueClassMemberNames) {
            appView.programClassPool.classesAccept(new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)));
            appView.programClassPool.classesAccept(new AllMemberVisitor(new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap)));
        } else {
            appView.programClassPool.classesAccept(new MultiClassVisitor(new ClassHierarchyTraveler(true, false, false, true, new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, true, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap))), new MapCleaner(descriptorMap)));
            appView.programClassPool.classesAccept(new MultiClassVisitor(new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)), new ClassHierarchyTraveler(false, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(false, false, false, true, new ClassAccessFilter(1024, 0, new ClassHierarchyTraveler(false, false, true, false, new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap))))), new ClassHierarchyTraveler(false, false, false, true, new ClassHierarchyTraveler(false, false, true, false, new AllMethodVisitor(new MemberAccessFilter(0, 1032, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap))))), new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap))), new MapCleaner(descriptorMap)));
        }
        SpecialNameFactory specialNameFactory = new SpecialNameFactory(new SimpleNameFactory());
        HashMap specialDescriptorMap = new HashMap();
        appView.programClassPool.classesAccept(new AllMemberVisitor(new MemberSpecialNameFilter(new MemberNameCollector(this.configuration.overloadAggressively, specialDescriptorMap))));
        appView.libraryClassPool.classesAccept(new AllMemberVisitor(new MemberSpecialNameFilter(new MemberNameCollector(this.configuration.overloadAggressively, specialDescriptorMap))));
        appView.programClassPool.classesAccept(new MultiClassVisitor(new ClassHierarchyTraveler(true, false, false, true, new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameConflictFixer(this.configuration.overloadAggressively, descriptorMap, warningPrinter, new MemberObfuscator(this.configuration.overloadAggressively, specialNameFactory, specialDescriptorMap))))), new MapCleaner(descriptorMap)));
        appView.programClassPool.classesAccept(new MultiClassVisitor(new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)), new ClassHierarchyTraveler(false, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberNameConflictFixer(this.configuration.overloadAggressively, descriptorMap, warningPrinter, new MemberObfuscator(this.configuration.overloadAggressively, specialNameFactory, specialDescriptorMap)))), new MapCleaner(descriptorMap)));
        int warningCount = ((WarningPrinter)warningPrinter).getWarningCount();
        if (warningCount > 0) {
            logger.warn("Warning: there were {} conflicting class member name mappings.", (Object)warningCount);
            logger.warn("         Your configuration may be inconsistent.");
            if (!this.configuration.ignoreWarnings) {
                logger.warn("         If you are sure the conflicts are harmless,");
                logger.warn("         you could try your luck using the '-ignorewarnings' option.");
            }
            logger.warn("         (https://www.guardsquare.com/proguard/manual/troubleshooting#mappingconflict2)");
            if (!this.configuration.ignoreWarnings) {
                throw new IOException("Please correct the above warnings first.");
            }
        }
        appView.programClassPool.classesAccept(new InstructionSequenceObfuscator(new KotlinIntrinsicsReplacementSequences(appView.programClassPool, appView.libraryClassPool)));
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept(new MultiClassVisitor(new ReferencedKotlinMetadataVisitor(new MultiKotlinMetadataVisitor(new KotlinPropertyNameObfuscator(nameFactory), new KotlinAliasNameObfuscator(nameFactory), new KotlinSyntheticClassFixer(), new KotlinObjectFixer(), new AllFunctionVisitor(new KotlinDefaultImplsMethodNameEqualizer(), new KotlinDefaultMethodNameEqualizer(), new KotlinFunctionToDefaultMethodVisitor(new InstructionSequenceObfuscator(new KotlinUnsupportedExceptionReplacementSequences(appView.programClassPool, appView.libraryClassPool)))), new KotlinClassKindFilter(kc -> kc.flags.isValue || kc.flags.isData, new KotlinSyntheticToStringObfuscator())))));
            appView.resourceFilePool.resourceFilesAccept(new ResourceFileProcessingFlagFilter(0, 0x400000, new KotlinModuleNameObfuscator(nameFactory)));
        }
        if (this.configuration.printMapping != null) {
            logger.info("Printing mapping to [{}]...", (Object)PrintWriterUtil.fileName(this.configuration.printMapping));
            PrintWriter mappingWriter = PrintWriterUtil.createPrintWriter(this.configuration.printMapping, out);
            try {
                appView.programClassPool.classesAcceptAlphabetically(new MappingPrinter(mappingWriter));
            }
            finally {
                PrintWriterUtil.closePrintWriter(this.configuration.printMapping, mappingWriter);
            }
        }
        if (this.configuration.addConfigurationDebugging) {
            appView.programClassPool.classesAccept(new RenamedFlagSetter());
        }
        ClassCounter obfuscatedClassCounter = new ClassCounter();
        MemberCounter obfuscatedFieldCounter = new MemberCounter();
        MemberCounter obfuscatedMethodCounter = new MemberCounter();
        ClassRenamer classRenamer = new ClassRenamer(new ProgramClassFilter(obfuscatedClassCounter), new ProgramMemberFilter(new MethodFilter(obfuscatedMethodCounter, obfuscatedFieldCounter)));
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new KotlinMultiFileFacadeFixer()));
        }
        appView.programClassPool.classesAccept(classRenamer);
        appView.libraryClassPool.classesAccept(classRenamer);
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new AllPropertyVisitor(new KotlinPropertyRenamer())));
        }
        appView.programClassPool.classesAccept(new ClassReferenceFixer(false));
        appView.libraryClassPool.classesAccept(new ClassReferenceFixer(false));
        appView.programClassPool.classesAccept(new MemberReferenceFixer(this.configuration.android));
        if (this.configuration.keepKotlinMetadata) {
            appView.programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new MultiKotlinMetadataVisitor(new AllTypeVisitor(new KotlinAliasReferenceFixer()), new KotlinCallableReferenceFixer(appView.programClassPool, appView.libraryClassPool))));
        }
        if (this.configuration.repackageClasses != null && this.configuration.allowAccessModification) {
            appView.programClassPool.classesAccept(new AccessFixer());
            appView.programClassPool.classesAccept(new OriginalClassNameFilter(null, new AllAttributeVisitor(new AllInnerClassesInfoVisitor(new InnerClassesAccessFixer()))));
        }
        appView.programClassPool.classesAccept(new AllMethodVisitor(new BridgeMethodFixer()));
        if (this.configuration.newSourceFileAttribute != null) {
            appView.programClassPool.classesAccept(new SourceFileRenamer(this.configuration.newSourceFileAttribute));
        }
        appView.programClassPool.classesAccept(new ConstantPoolShrinker());
        logger.info("  Number of obfuscated classes:                  {}", (Object)obfuscatedClassCounter.getCount());
        logger.info("  Number of obfuscated fields:                   {}", (Object)obfuscatedFieldCounter.getCount());
        logger.info("  Number of obfuscated methods:                  {}", (Object)obfuscatedMethodCounter.getCount());
    }
}

