/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import proguard.ClassSpecification;
import proguard.KeepClassSpecification;
import proguard.MemberSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.gui.GUIResources;
import proguard.gui.MemberSpecificationsPanel;

final class ClassSpecificationDialog
extends JDialog {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private final JTextArea commentsTextArea = new JTextArea(4, 20);
    private final JCheckBox keepClassesCheckBox = new JCheckBox(ClassSpecificationDialog.msg("keepClasses"));
    private final JCheckBox keepClassMembersCheckBox = new JCheckBox(ClassSpecificationDialog.msg("keepClassMembers"));
    private final JCheckBox keepClassesWithMembersCheckBox = new JCheckBox(ClassSpecificationDialog.msg("keepClassesWithMembers"));
    private final JCheckBox keepDescriptorClassesCheckBox = new JCheckBox(ClassSpecificationDialog.msg("keepDescriptorClasses"));
    private final JCheckBox keepCodeCheckBox = new JCheckBox(ClassSpecificationDialog.msg("keepCode"));
    private final JCheckBox allowShrinkingCheckBox = new JCheckBox(ClassSpecificationDialog.msg("allowShrinking"));
    private final JCheckBox allowOptimizationCheckBox = new JCheckBox(ClassSpecificationDialog.msg("allowOptimization"));
    private final JCheckBox allowObfuscationCheckBox = new JCheckBox(ClassSpecificationDialog.msg("allowObfuscation"));
    private final JTextField conditionCommentsField = new JTextField(20);
    private final ClassSpecificationDialog conditionDialog;
    private final JRadioButton[] publicRadioButtons;
    private final JRadioButton[] finalRadioButtons;
    private final JRadioButton[] abstractRadioButtons;
    private final JRadioButton[] interfaceRadioButtons;
    private final JRadioButton[] annotationRadioButtons;
    private final JRadioButton[] enumRadioButtons;
    private final JRadioButton[] syntheticRadioButtons;
    private final JTextField annotationTypeTextField = new JTextField(20);
    private final JTextField classNameTextField = new JTextField(20);
    private final JTextField extendsAnnotationTypeTextField = new JTextField(20);
    private final JTextField extendsClassNameTextField = new JTextField(20);
    private final MemberSpecificationsPanel memberSpecificationsPanel;
    private int returnValue;

    public ClassSpecificationDialog(JFrame owner, boolean includeKeepSettings, boolean includeFieldButton) {
        super(owner, ClassSpecificationDialog.msg("specifyClasses"), true);
        this.setResizable(true);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.insets = new Insets(1, 2, 1, 2);
        GridBagConstraints constraintsStretch = new GridBagConstraints();
        constraintsStretch.fill = 2;
        constraintsStretch.weightx = 1.0;
        constraintsStretch.anchor = 17;
        constraintsStretch.insets = constraints.insets;
        GridBagConstraints constraintsLast = new GridBagConstraints();
        constraintsLast.gridwidth = 0;
        constraintsLast.anchor = 17;
        constraintsLast.insets = constraints.insets;
        GridBagConstraints constraintsLastStretch = new GridBagConstraints();
        constraintsLastStretch.gridwidth = 0;
        constraintsLastStretch.fill = 2;
        constraintsLastStretch.weightx = 1.0;
        constraintsLastStretch.anchor = 17;
        constraintsLastStretch.insets = constraints.insets;
        GridBagConstraints panelConstraints = new GridBagConstraints();
        panelConstraints.gridwidth = 0;
        panelConstraints.fill = 2;
        panelConstraints.weightx = 1.0;
        panelConstraints.weighty = 0.0;
        panelConstraints.anchor = 18;
        panelConstraints.insets = constraints.insets;
        GridBagConstraints stretchPanelConstraints = new GridBagConstraints();
        stretchPanelConstraints.gridwidth = 0;
        stretchPanelConstraints.fill = 1;
        stretchPanelConstraints.weightx = 1.0;
        stretchPanelConstraints.weighty = 1.0;
        stretchPanelConstraints.anchor = 18;
        stretchPanelConstraints.insets = constraints.insets;
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 10;
        labelConstraints.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints lastLabelConstraints = new GridBagConstraints();
        lastLabelConstraints.gridwidth = 0;
        lastLabelConstraints.anchor = 10;
        lastLabelConstraints.insets = labelConstraints.insets;
        GridBagConstraints advancedButtonConstraints = new GridBagConstraints();
        advancedButtonConstraints.weightx = 1.0;
        advancedButtonConstraints.weighty = 1.0;
        advancedButtonConstraints.anchor = 16;
        advancedButtonConstraints.insets = new Insets(4, 4, 8, 4);
        GridBagConstraints okButtonConstraints = new GridBagConstraints();
        okButtonConstraints.weightx = 1.0;
        okButtonConstraints.weighty = 1.0;
        okButtonConstraints.anchor = 14;
        okButtonConstraints.insets = advancedButtonConstraints.insets;
        GridBagConstraints cancelButtonConstraints = new GridBagConstraints();
        cancelButtonConstraints.gridwidth = 0;
        cancelButtonConstraints.weighty = 1.0;
        cancelButtonConstraints.anchor = 14;
        cancelButtonConstraints.insets = advancedButtonConstraints.insets;
        GridBagLayout layout = new GridBagLayout();
        Border etchedBorder = BorderFactory.createEtchedBorder(0);
        JPanel commentsPanel = new JPanel(layout);
        commentsPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("comments")));
        JScrollPane commentsScrollPane = new JScrollPane(this.commentsTextArea);
        commentsScrollPane.setBorder(this.classNameTextField.getBorder());
        commentsPanel.add((Component)ClassSpecificationDialog.tip(commentsScrollPane, "commentsTip"), constraintsLastStretch);
        JPanel keepOptionPanel = new JPanel(layout);
        keepOptionPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("keepTitle")));
        keepOptionPanel.add((Component)ClassSpecificationDialog.tip(this.keepClassesCheckBox, "keepClassesTip"), constraintsLastStretch);
        keepOptionPanel.add((Component)ClassSpecificationDialog.tip(this.keepClassMembersCheckBox, "keepClassMembersTip"), constraintsLastStretch);
        keepOptionPanel.add((Component)ClassSpecificationDialog.tip(this.keepClassesWithMembersCheckBox, "keepClassesWithMembersTip"), constraintsLastStretch);
        final JPanel alsoKeepOptionPanel = new JPanel(layout);
        alsoKeepOptionPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("alsoKeepTitle")));
        alsoKeepOptionPanel.add((Component)ClassSpecificationDialog.tip(this.keepDescriptorClassesCheckBox, "keepDescriptorClassesTip"), constraintsLastStretch);
        alsoKeepOptionPanel.add((Component)ClassSpecificationDialog.tip(this.keepCodeCheckBox, "keepCodeTip"), constraintsLastStretch);
        final JPanel allowOptionPanel = new JPanel(layout);
        allowOptionPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("allowTitle")));
        allowOptionPanel.add((Component)ClassSpecificationDialog.tip(this.allowShrinkingCheckBox, "allowShrinkingTip"), constraintsLastStretch);
        allowOptionPanel.add((Component)ClassSpecificationDialog.tip(this.allowOptimizationCheckBox, "allowOptimizationTip"), constraintsLastStretch);
        allowOptionPanel.add((Component)ClassSpecificationDialog.tip(this.allowObfuscationCheckBox, "allowObfuscationTip"), constraintsLastStretch);
        this.conditionDialog = includeKeepSettings ? new ClassSpecificationDialog(owner, false, true) : null;
        final JPanel conditionPanel = new JPanel(layout);
        conditionPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("conditionTitle")));
        JButton conditionButton = new JButton(ClassSpecificationDialog.msg("edit"));
        conditionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ClassSpecification originalCondition = ClassSpecificationDialog.this.conditionDialog.getClassSpecification();
                int returnValue = ClassSpecificationDialog.this.conditionDialog.showDialog();
                if (returnValue == 0) {
                    ClassSpecification condition = ClassSpecificationDialog.this.conditionDialog.getClassSpecification();
                    ClassSpecificationDialog.this.conditionCommentsField.setText(ClassSpecificationDialog.this.label(condition.equals(new ClassSpecification()) ? null : condition));
                } else {
                    ClassSpecificationDialog.this.conditionDialog.setClassSpecification(originalCondition);
                }
            }
        });
        this.conditionCommentsField.setEditable(false);
        conditionPanel.add((Component)ClassSpecificationDialog.tip(this.conditionCommentsField, "commentsTip"), constraintsStretch);
        conditionPanel.add((Component)ClassSpecificationDialog.tip(conditionButton, "editConditionTip"), constraintsLast);
        JPanel accessPanel = new JPanel(layout);
        accessPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("access")));
        accessPanel.add(Box.createGlue(), labelConstraints);
        accessPanel.add((Component)ClassSpecificationDialog.tip(new JLabel(ClassSpecificationDialog.msg("required")), "requiredTip"), labelConstraints);
        accessPanel.add((Component)ClassSpecificationDialog.tip(new JLabel(ClassSpecificationDialog.msg("not")), "notTip"), labelConstraints);
        accessPanel.add((Component)ClassSpecificationDialog.tip(new JLabel(ClassSpecificationDialog.msg("dontCare")), "dontCareTip"), labelConstraints);
        accessPanel.add(Box.createGlue(), constraintsLastStretch);
        this.publicRadioButtons = this.addRadioButtonTriplet("Public", accessPanel);
        this.finalRadioButtons = this.addRadioButtonTriplet("Final", accessPanel);
        this.abstractRadioButtons = this.addRadioButtonTriplet("Abstract", accessPanel);
        this.interfaceRadioButtons = this.addRadioButtonTriplet("Interface", accessPanel);
        this.annotationRadioButtons = this.addRadioButtonTriplet("Annotation", accessPanel);
        this.enumRadioButtons = this.addRadioButtonTriplet("Enum", accessPanel);
        this.syntheticRadioButtons = this.addRadioButtonTriplet("Synthetic", accessPanel);
        final JPanel annotationTypePanel = new JPanel(layout);
        annotationTypePanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("annotation")));
        annotationTypePanel.add((Component)ClassSpecificationDialog.tip(this.annotationTypeTextField, "classNameTip"), constraintsLastStretch);
        JPanel classNamePanel = new JPanel(layout);
        classNamePanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("class")));
        classNamePanel.add((Component)ClassSpecificationDialog.tip(this.classNameTextField, "classNameTip"), constraintsLastStretch);
        final JPanel extendsAnnotationTypePanel = new JPanel(layout);
        extendsAnnotationTypePanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("extendsImplementsAnnotation")));
        extendsAnnotationTypePanel.add((Component)ClassSpecificationDialog.tip(this.extendsAnnotationTypeTextField, "classNameTip"), constraintsLastStretch);
        JPanel extendsClassNamePanel = new JPanel(layout);
        extendsClassNamePanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("extendsImplementsClass")));
        extendsClassNamePanel.add((Component)ClassSpecificationDialog.tip(this.extendsClassNameTextField, "classNameTip"), constraintsLastStretch);
        this.memberSpecificationsPanel = new MemberSpecificationsPanel(this, includeFieldButton);
        this.memberSpecificationsPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("classMembers")));
        final JButton advancedButton = new JButton(ClassSpecificationDialog.msg("basic"));
        advancedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean visible = !alsoKeepOptionPanel.isVisible();
                alsoKeepOptionPanel.setVisible(visible);
                allowOptionPanel.setVisible(visible);
                annotationTypePanel.setVisible(visible);
                extendsAnnotationTypePanel.setVisible(visible);
                conditionPanel.setVisible(visible);
                advancedButton.setText(ClassSpecificationDialog.msg(visible ? "basic" : "advanced"));
                ClassSpecificationDialog.this.pack();
            }
        });
        advancedButton.doClick();
        JButton okButton = new JButton(ClassSpecificationDialog.msg("ok"));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassSpecificationDialog.this.returnValue = 0;
                ClassSpecificationDialog.this.hide();
            }
        });
        JButton cancelButton = new JButton(ClassSpecificationDialog.msg("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassSpecificationDialog.this.hide();
            }
        });
        JPanel mainPanel = new JPanel(layout);
        mainPanel.add((Component)ClassSpecificationDialog.tip(commentsPanel, "commentsTip"), panelConstraints);
        if (includeKeepSettings) {
            mainPanel.add((Component)ClassSpecificationDialog.tip(keepOptionPanel, "keepTitleTip"), panelConstraints);
            mainPanel.add((Component)ClassSpecificationDialog.tip(alsoKeepOptionPanel, "alsoKeepTitleTip"), panelConstraints);
            mainPanel.add((Component)ClassSpecificationDialog.tip(allowOptionPanel, "allowTitleTip"), panelConstraints);
            mainPanel.add((Component)ClassSpecificationDialog.tip(conditionPanel, "conditionTip"), panelConstraints);
        }
        mainPanel.add((Component)ClassSpecificationDialog.tip(accessPanel, "accessTip"), panelConstraints);
        mainPanel.add((Component)ClassSpecificationDialog.tip(annotationTypePanel, "annotationTip"), panelConstraints);
        mainPanel.add((Component)ClassSpecificationDialog.tip(classNamePanel, "classTip"), panelConstraints);
        mainPanel.add((Component)ClassSpecificationDialog.tip(extendsAnnotationTypePanel, "extendsImplementsAnnotationTip"), panelConstraints);
        mainPanel.add((Component)ClassSpecificationDialog.tip(extendsClassNamePanel, "extendsImplementsClassTip"), panelConstraints);
        mainPanel.add((Component)ClassSpecificationDialog.tip(this.memberSpecificationsPanel, "classMembersTip"), stretchPanelConstraints);
        mainPanel.add((Component)ClassSpecificationDialog.tip(advancedButton, "advancedTip"), advancedButtonConstraints);
        mainPanel.add((Component)okButton, okButtonConstraints);
        mainPanel.add((Component)cancelButton, cancelButtonConstraints);
        this.getContentPane().add(new JScrollPane(mainPanel));
    }

    private JRadioButton[] addRadioButtonTriplet(String labelText, JPanel panel) {
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 17;
        labelConstraints.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.insets = labelConstraints.insets;
        GridBagConstraints lastGlueConstraints = new GridBagConstraints();
        lastGlueConstraints.gridwidth = 0;
        lastGlueConstraints.weightx = 1.0;
        JRadioButton radioButton0 = new JRadioButton();
        JRadioButton radioButton1 = new JRadioButton();
        JRadioButton radioButton2 = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(radioButton0);
        buttonGroup.add(radioButton1);
        buttonGroup.add(radioButton2);
        panel.add((Component)new JLabel(labelText), labelConstraints);
        panel.add((Component)radioButton0, buttonConstraints);
        panel.add((Component)radioButton1, buttonConstraints);
        panel.add((Component)radioButton2, buttonConstraints);
        panel.add(Box.createGlue(), lastGlueConstraints);
        return new JRadioButton[]{radioButton0, radioButton1, radioButton2};
    }

    public void setKeepSpecification(KeepClassSpecification keepClassSpecification) {
        boolean markClasses = keepClassSpecification.markClasses;
        boolean markClassMembers = keepClassSpecification.markClassMembers;
        boolean markConditionally = keepClassSpecification.markConditionally;
        boolean markDescriptorClasses = keepClassSpecification.markDescriptorClasses;
        boolean markCodeAttributes = keepClassSpecification.markCodeAttributes;
        boolean allowShrinking = keepClassSpecification.allowShrinking;
        boolean allowOptimization = keepClassSpecification.allowOptimization;
        boolean allowObfuscation = keepClassSpecification.allowObfuscation;
        ClassSpecification condition = keepClassSpecification.condition;
        this.keepClassesCheckBox.setSelected(markClasses);
        this.keepClassMembersCheckBox.setSelected(markClassMembers);
        this.keepClassesWithMembersCheckBox.setSelected(markDescriptorClasses);
        this.keepDescriptorClassesCheckBox.setSelected(markDescriptorClasses);
        this.keepCodeCheckBox.setSelected(markCodeAttributes);
        this.allowShrinkingCheckBox.setSelected(allowShrinking);
        this.allowOptimizationCheckBox.setSelected(allowOptimization);
        this.allowObfuscationCheckBox.setSelected(allowObfuscation);
        this.conditionCommentsField.setText(this.label(condition));
        this.conditionDialog.setClassSpecification(condition != null ? condition : new ClassSpecification());
        this.setClassSpecification(keepClassSpecification);
    }

    public void setClassSpecification(ClassSpecification classSpecification) {
        String comments = classSpecification.comments;
        String annotationType = classSpecification.annotationType;
        String className = classSpecification.className;
        String extendsAnnotationType = classSpecification.extendsAnnotationType;
        String extendsClassName = classSpecification.extendsClassName;
        List<MemberSpecification> keepFieldOptions = classSpecification.fieldSpecifications;
        List<MemberSpecification> keepMethodOptions = classSpecification.methodSpecifications;
        this.commentsTextArea.setText(comments == null ? "" : comments);
        this.setClassSpecificationRadioButtons(classSpecification, 1, this.publicRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 16, this.finalRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 1024, this.abstractRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 512, this.interfaceRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 8192, this.annotationRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 16384, this.enumRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 4096, this.syntheticRadioButtons);
        this.annotationTypeTextField.setText(annotationType == null ? "" : ClassUtil.externalType(annotationType));
        this.classNameTextField.setText(className == null ? "*" : ClassUtil.externalClassName(className));
        this.extendsAnnotationTypeTextField.setText(extendsAnnotationType == null ? "" : ClassUtil.externalType(extendsAnnotationType));
        this.extendsClassNameTextField.setText(extendsClassName == null ? "" : ClassUtil.externalClassName(extendsClassName));
        this.memberSpecificationsPanel.setMemberSpecifications(keepFieldOptions, keepMethodOptions);
    }

    public KeepClassSpecification getKeepSpecification() {
        boolean markClasses = this.keepClassesCheckBox.isSelected();
        boolean markClassMembers = this.keepClassMembersCheckBox.isSelected();
        boolean markConditionally = this.keepClassesWithMembersCheckBox.isSelected();
        boolean markDescriptorClasses = this.keepDescriptorClassesCheckBox.isSelected();
        boolean markCodeAttributes = this.keepCodeCheckBox.isSelected();
        boolean allowShrinking = this.allowShrinkingCheckBox.isSelected();
        boolean allowOptimization = this.allowOptimizationCheckBox.isSelected();
        boolean allowObfuscation = this.allowObfuscationCheckBox.isSelected();
        ClassSpecification condition = this.conditionDialog.getClassSpecification();
        return new KeepClassSpecification(markClasses, markClassMembers, markConditionally, markDescriptorClasses, markCodeAttributes, allowShrinking, allowOptimization, allowObfuscation, condition.equals(new ClassSpecification()) ? null : condition, this.getClassSpecification());
    }

    public ClassSpecification getClassSpecification() {
        String comments = this.commentsTextArea.getText();
        String annotationType = this.annotationTypeTextField.getText();
        String className = this.classNameTextField.getText();
        String extendsAnnotationType = this.extendsAnnotationTypeTextField.getText();
        String extendsClassName = this.extendsClassNameTextField.getText();
        ClassSpecification classSpecification = new ClassSpecification(comments.equals("") ? null : comments, 0, 0, annotationType.equals("") ? null : ClassUtil.internalType(annotationType), className.equals("") || className.equals("*") ? null : ClassUtil.internalClassName(className), extendsAnnotationType.equals("") ? null : ClassUtil.internalType(extendsAnnotationType), extendsClassName.equals("") ? null : ClassUtil.internalClassName(extendsClassName));
        this.getClassSpecificationRadioButtons(classSpecification, 1, this.publicRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 16, this.finalRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 1024, this.abstractRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 512, this.interfaceRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 8192, this.annotationRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 16384, this.enumRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 4096, this.syntheticRadioButtons);
        classSpecification.fieldSpecifications = this.memberSpecificationsPanel.getMemberSpecifications(true);
        classSpecification.methodSpecifications = this.memberSpecificationsPanel.getMemberSpecifications(false);
        return classSpecification;
    }

    public int showDialog() {
        this.returnValue = 1;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.show();
        return this.returnValue;
    }

    public String label(ClassSpecification classSpecification) {
        return this.label(classSpecification, -1);
    }

    public String label(ClassSpecification classSpecification, int index) {
        return classSpecification == null ? ClassSpecificationDialog.msg("none") : (classSpecification.comments != null ? classSpecification.comments.trim() : (classSpecification.className != null ? ClassSpecificationDialog.msg("class") + ' ' + ClassUtil.externalClassName(classSpecification.className) : (classSpecification.annotationType != null ? ClassSpecificationDialog.msg("classesAnnotatedWith") + ' ' + ClassUtil.externalType(classSpecification.annotationType) : (classSpecification.extendsClassName != null ? ClassSpecificationDialog.msg("extensionsOf") + ' ' + ClassUtil.externalClassName(classSpecification.extendsClassName) : (classSpecification.extendsAnnotationType != null ? ClassSpecificationDialog.msg("extensionsOfClassesAnnotatedWith") + ' ' + ClassUtil.externalType(classSpecification.extendsAnnotationType) : (index >= 0 ? ClassSpecificationDialog.msg("specificationNumber") + index : ClassSpecificationDialog.msg("specification")))))));
    }

    private void setClassSpecificationRadioButtons(ClassSpecification classSpecification, int flag, JRadioButton[] radioButtons) {
        int index = (classSpecification.requiredSetAccessFlags & flag) != 0 ? 0 : ((classSpecification.requiredUnsetAccessFlags & flag) != 0 ? 1 : 2);
        radioButtons[index].setSelected(true);
    }

    private void getClassSpecificationRadioButtons(ClassSpecification classSpecification, int flag, JRadioButton[] radioButtons) {
        if (radioButtons[0].isSelected()) {
            classSpecification.requiredSetAccessFlags |= flag;
        } else if (radioButtons[1].isSelected()) {
            classSpecification.requiredUnsetAccessFlags |= flag;
        }
    }

    private static JComponent tip(JComponent component, String messageKey) {
        component.setToolTipText(ClassSpecificationDialog.msg(messageKey));
        return component;
    }

    private static String msg(String messageKey) {
        return GUIResources.getMessage(messageKey);
    }
}

