/*
 * Decompiled with CFR 0.152.
 */
package proguard.exception;

public class ProguardCoreException
extends RuntimeException {
    private final int componentErrorId;
    private final Object[] errorParameters;

    public ProguardCoreException(int componentErrorId, String message, Object ... errorParameters) {
        this(componentErrorId, null, message, errorParameters);
    }

    public ProguardCoreException(int componentErrorId, Throwable cause, String message, Object ... errorParameters) {
        super(message != null ? String.format(message, errorParameters) : null, cause);
        this.componentErrorId = componentErrorId;
        this.errorParameters = errorParameters;
    }

    public int getComponentErrorId() {
        return this.componentErrorId;
    }

    public Object[] getErrorParameters() {
        return this.errorParameters;
    }

    public static class Builder {
        private final String message;
        private final int componentErrorId;
        private Object[] errorParameters = new Object[0];
        private Throwable cause = null;

        public Builder(String message, int componentErrorId) {
            this.message = message;
            this.componentErrorId = componentErrorId;
        }

        public Builder errorParameters(Object ... errorParameters) {
            this.errorParameters = errorParameters;
            return this;
        }

        public Builder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        public ProguardCoreException build() {
            return new ProguardCoreException(this.componentErrorId, this.cause, this.message, this.errorParameters);
        }
    }
}

