/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.executor;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Optional;
import proguard.classfile.MethodDescriptor;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.MethodResult;
import proguard.evaluation.ValueCalculator;
import proguard.evaluation.executor.Executor;
import proguard.evaluation.executor.MethodExecutionInfo;
import proguard.evaluation.executor.instancehandler.ExecutorInstanceHandler;
import proguard.evaluation.value.DetailedArrayReferenceValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.object.AnalyzedObject;

public abstract class ReflectionExecutor
implements Executor {
    @Override
    public MethodResult getMethodResult(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        Optional<MethodResult> fallbackResultOptional = this.createFallbackResultIfInvalidParameters(methodExecutionInfo, valueCalculator);
        if (fallbackResultOptional.isPresent()) {
            return fallbackResultOptional.get();
        }
        ReflectionParameters reflectionParameters = new ReflectionParameters(methodExecutionInfo.getSignature().descriptor, methodExecutionInfo.getParameters());
        if (methodExecutionInfo.isConstructor()) {
            return this.executeConstructor(methodExecutionInfo, valueCalculator, reflectionParameters);
        }
        return this.executeMethod(methodExecutionInfo, valueCalculator, reflectionParameters);
    }

    private Optional<MethodResult> createFallbackResultIfInvalidParameters(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        ReferenceValue instance = methodExecutionInfo.getInstanceOrNullIfStatic();
        if (!(methodExecutionInfo.isStatic() || instance != null && instance.isSpecific())) {
            return Optional.of(MethodResult.invalidResult());
        }
        if (instance != null && instance.isParticular() && instance.getValue().isModeled()) {
            return Optional.of(this.createFallbackResultMethod(methodExecutionInfo, valueCalculator));
        }
        if (methodExecutionInfo.isInstanceMethod() && (!instance.isParticular() || ReflectionExecutor.isNonPreciseParticularValue(instance)) || methodExecutionInfo.getParameters().stream().anyMatch(value -> !value.isParticular() || ReflectionExecutor.isNonPreciseParticularValue(value))) {
            if (methodExecutionInfo.isConstructor()) {
                return Optional.of(this.createFallbackResultConstructor(methodExecutionInfo, valueCalculator));
            }
            return Optional.of(this.createFallbackResultMethod(methodExecutionInfo, valueCalculator));
        }
        return Optional.empty();
    }

    private static boolean isNonPreciseParticularValue(Value value) {
        if (!value.isParticular()) {
            throw new IllegalStateException("This method should not be called for non particular values");
        }
        return value instanceof ReferenceValue && !value.referenceValue().getValue().isPrecise() && !(value instanceof DetailedArrayReferenceValue);
    }

    private MethodResult executeMethod(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator, ReflectionParameters reflectionParameters) {
        try {
            Class<?> baseClass = Class.forName(ClassUtil.externalClassName(methodExecutionInfo.getSignature().getClassName()));
            Object callingInstance = null;
            boolean isCallingInstanceMutable = false;
            if (!methodExecutionInfo.isStatic()) {
                Optional<InstanceCopyResult> objectInstanceResultOptional = this.getInstanceOrCopyIfMutable(methodExecutionInfo.getSpecificInstance());
                if (!objectInstanceResultOptional.isPresent()) {
                    return MethodResult.invalidResult();
                }
                callingInstance = objectInstanceResultOptional.get().getInstance().getPreciseValue();
                isCallingInstanceMutable = objectInstanceResultOptional.get().isMutable();
            }
            MethodResult.Builder resultBuilder = new MethodResult.Builder();
            Object returnResult = baseClass.getMethod(methodExecutionInfo.getSignature().method, reflectionParameters.classes).invoke(callingInstance, reflectionParameters.objects);
            Object newReferenceId = null;
            if (!methodExecutionInfo.isStatic() && returnResult == callingInstance) {
                newReferenceId = methodExecutionInfo.getSpecificInstance().id;
            }
            if (methodExecutionInfo.getReturnType().charAt(0) != 'V') {
                Value returnValue = valueCalculator.apply(methodExecutionInfo.getReturnType(), methodExecutionInfo.getReturnClass(), true, returnResult, ClassUtil.isExtendable(methodExecutionInfo.getReturnClass()), newReferenceId);
                resultBuilder.setReturnValue(returnValue);
                if (isCallingInstanceMutable && newReferenceId != null) {
                    resultBuilder.setUpdatedInstance(returnValue.referenceValue());
                }
            }
            return resultBuilder.build();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return MethodResult.invalidResult();
        }
    }

    private MethodResult executeConstructor(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator, ReflectionParameters reflectionParameters) {
        try {
            Class<?> baseClass = Class.forName(ClassUtil.externalClassName(methodExecutionInfo.getSignature().getClassName()));
            Object newInstance = baseClass.getConstructor(reflectionParameters.classes).newInstance(reflectionParameters.objects);
            return new MethodResult.Builder().setUpdatedInstance(valueCalculator.apply(methodExecutionInfo.getTargetType(), methodExecutionInfo.getTargetClass(), true, newInstance, false, methodExecutionInfo.getSpecificInstance().id).referenceValue()).build();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            return MethodResult.invalidResult();
        }
    }

    private MethodResult createFallbackResultMethod(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        boolean returnsInstance;
        MethodResult.Builder builder = new MethodResult.Builder();
        if (methodExecutionInfo.getReturnType().charAt(0) == 'V') {
            return builder.build();
        }
        Object newReferenceId = null;
        boolean bl = returnsInstance = methodExecutionInfo.returnsSameTypeAsInstance() && this.getDefaultInstanceHandler().returnsOwnInstance(methodExecutionInfo.getSignature().getClassName(), methodExecutionInfo.getSignature().method);
        if (returnsInstance) {
            newReferenceId = methodExecutionInfo.getSpecificInstance().id;
        }
        Value returnValue = valueCalculator.apply(methodExecutionInfo.getReturnType(), methodExecutionInfo.getReturnClass(), false, null, ClassUtil.isExtendable(methodExecutionInfo.getReturnClass()), newReferenceId);
        builder.setReturnValue(returnValue);
        if (returnsInstance) {
            builder.setUpdatedInstance(returnValue.referenceValue());
        }
        return builder.build();
    }

    private MethodResult createFallbackResultConstructor(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        MethodResult.Builder builder = new MethodResult.Builder();
        builder.setUpdatedInstance(valueCalculator.apply(methodExecutionInfo.getTargetType(), methodExecutionInfo.getTargetClass(), false, null, false, methodExecutionInfo.getSpecificInstance().id).referenceValue());
        return builder.build();
    }

    protected abstract Optional<InstanceCopyResult> getInstanceOrCopyIfMutable(ReferenceValue var1);

    protected abstract ExecutorInstanceHandler getDefaultInstanceHandler();

    private static class ReflectionParameters {
        private final Object[] objects;
        private final Class<?>[] classes;

        public ReflectionParameters(MethodDescriptor descriptor, List<Value> nonInstanceParameters) throws IllegalArgumentException {
            int len = nonInstanceParameters.size();
            if (descriptor.getArgumentTypes().size() != len) {
                throw new IllegalArgumentException("Parameter count does not match the method descriptor.");
            }
            this.objects = new Object[len];
            this.classes = new Class[len];
            for (int index = 0; index < len; ++index) {
                Class<?> innerClass;
                String internalType = descriptor.getArgumentTypes().get(index);
                Value parameter = nonInstanceParameters.get(index);
                if (!ClassUtil.isInternalArrayType(internalType)) {
                    Class<?> cls;
                    try {
                        cls = ReflectionParameters.getSingleClass(internalType);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalArgumentException("Descriptor type refers to an unknown class.");
                    }
                    this.classes[index] = cls;
                    this.objects[index] = ReflectionParameters.getSingleObject(cls, parameter);
                    continue;
                }
                String innerType = ClassUtil.internalTypeFromArrayType(internalType);
                if (ClassUtil.isInternalArrayType(innerType)) {
                    throw new IllegalArgumentException("Only 1D arrays are supported.");
                }
                Value[] valuesArray = (Value[])parameter.referenceValue().value();
                try {
                    innerClass = ReflectionParameters.getSingleClass(innerType);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Descriptor type refers to an unknown class.");
                }
                Object arrayObject = ReflectionParameters.getArrayObject(innerClass, valuesArray);
                this.classes[index] = arrayObject == null ? Array.newInstance(innerClass, 0).getClass() : arrayObject.getClass();
                this.objects[index] = arrayObject;
            }
        }

        private static Class<?> getSingleClass(String type) throws ClassNotFoundException {
            switch (type.charAt(0)) {
                case 'V': {
                    return Void.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'L': {
                    String internalClass = ClassUtil.internalClassNameFromClassType(type);
                    return Class.forName(ClassUtil.externalClassName(internalClass));
                }
            }
            throw new ClassNotFoundException();
        }

        private static int getIntValue(Value value) {
            return value.integerValue().value();
        }

        private static char getCharValue(Value value) {
            return (char)value.integerValue().value();
        }

        private static boolean getBooleanValue(Value value) {
            return value.integerValue().value() != 0;
        }

        private static byte getByteValue(Value value) {
            return (byte)value.integerValue().value();
        }

        private static short getShortValue(Value value) {
            return (short)value.integerValue().value();
        }

        private static Object getSingleObject(Class<?> cls, Value value) {
            switch (value.computationalType()) {
                case 1: {
                    return cls == Character.TYPE || cls == Character.class ? Character.valueOf(ReflectionParameters.getCharValue(value)) : (cls == Byte.TYPE || cls == Byte.class ? Byte.valueOf(ReflectionParameters.getByteValue(value)) : (cls == Short.TYPE || cls == Short.class ? Short.valueOf(ReflectionParameters.getShortValue(value)) : (cls == Boolean.TYPE || cls == Boolean.class ? (Comparable<Boolean>)Boolean.valueOf(ReflectionParameters.getBooleanValue(value)) : (Comparable<Boolean>)Integer.valueOf(ReflectionParameters.getIntValue(value)))));
                }
                case 2: {
                    return value.longValue().value();
                }
                case 3: {
                    return Float.valueOf(value.floatValue().value());
                }
                case 4: {
                    return value.doubleValue().value();
                }
                case 5: {
                    return value.referenceValue().value();
                }
            }
            return null;
        }

        private static Object getArrayObject(Class<?> cls, Value[] values2) {
            if (values2 == null) {
                return null;
            }
            int length = values2.length;
            switch (cls.getName()) {
                case "int": 
                case "java.lang.Integer": {
                    int[] arrayOfIntegers = new int[length];
                    for (int index = 0; index < length; ++index) {
                        arrayOfIntegers[index] = ReflectionParameters.getIntValue(values2[index]);
                    }
                    return arrayOfIntegers;
                }
                case "long": 
                case "java.lang.Long": {
                    long[] arrayOfLongs = new long[length];
                    for (int index = 0; index < length; ++index) {
                        arrayOfLongs[index] = values2[index].longValue().value();
                    }
                    return arrayOfLongs;
                }
                case "char": 
                case "java.lang.Character": {
                    char[] arrayOfChars = new char[length];
                    for (int index = 0; index < length; ++index) {
                        arrayOfChars[index] = ReflectionParameters.getCharValue(values2[index]);
                    }
                    return arrayOfChars;
                }
                case "byte": 
                case "java.lang.Byte": {
                    byte[] arrayOfBytes = new byte[length];
                    for (int index = 0; index < length; ++index) {
                        arrayOfBytes[index] = ReflectionParameters.getByteValue(values2[index]);
                    }
                    return arrayOfBytes;
                }
                case "short": 
                case "java.lang.Short": {
                    short[] arrayOfShorts = new short[length];
                    for (int index = 0; index < length; ++index) {
                        arrayOfShorts[index] = ReflectionParameters.getShortValue(values2[index]);
                    }
                    return arrayOfShorts;
                }
                case "boolean": 
                case "java.lang.Boolean": {
                    boolean[] arrayOfBooleans = new boolean[length];
                    for (int index = 0; index < length; ++index) {
                        arrayOfBooleans[index] = ReflectionParameters.getBooleanValue(values2[index]);
                    }
                    return arrayOfBooleans;
                }
                case "float": 
                case "java.lang.Float": {
                    float[] arrayOfFloats = new float[length];
                    for (int index = 0; index < length; ++index) {
                        arrayOfFloats[index] = values2[index].floatValue().value();
                    }
                    return arrayOfFloats;
                }
                case "double": 
                case "java.lang.Double": {
                    double[] arrayOfDoubles = new double[length];
                    for (int index = 0; index < length; ++index) {
                        arrayOfDoubles[index] = values2[index].doubleValue().value();
                    }
                    return arrayOfDoubles;
                }
            }
            Object[] arrayOfObjects = (Object[])Array.newInstance(cls, length);
            for (int index = 0; index < length; ++index) {
                arrayOfObjects[index] = values2[index].referenceValue().value();
            }
            return arrayOfObjects;
        }
    }

    public static class InstanceCopyResult {
        private final AnalyzedObject instance;
        private final boolean isMutable;

        public InstanceCopyResult(AnalyzedObject instance, boolean isMutable) {
            this.instance = instance;
            this.isMutable = isMutable;
        }

        public AnalyzedObject getInstance() {
            return this.instance;
        }

        public boolean isMutable() {
            return this.isMutable;
        }
    }
}

