/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.metadata.Attributes;
import kotlin.metadata.ClassKind;
import kotlin.metadata.InconsistentKotlinMetadataException;
import kotlin.metadata.KmClass;
import kotlin.metadata.KmClassifier;
import kotlin.metadata.KmConstructor;
import kotlin.metadata.KmContract;
import kotlin.metadata.KmEffect;
import kotlin.metadata.KmEffectExpression;
import kotlin.metadata.KmEffectInvocationKind;
import kotlin.metadata.KmEffectType;
import kotlin.metadata.KmFlexibleTypeUpperBound;
import kotlin.metadata.KmFunction;
import kotlin.metadata.KmPackage;
import kotlin.metadata.KmProperty;
import kotlin.metadata.KmPropertyAccessorAttributes;
import kotlin.metadata.KmType;
import kotlin.metadata.KmTypeAlias;
import kotlin.metadata.KmTypeParameter;
import kotlin.metadata.KmTypeProjection;
import kotlin.metadata.KmValueParameter;
import kotlin.metadata.KmVariance;
import kotlin.metadata.KmVersionRequirement;
import kotlin.metadata.MemberKind;
import kotlin.metadata.Modality;
import kotlin.metadata.Visibility;
import kotlin.metadata.jvm.JvmAttributes;
import kotlin.metadata.jvm.JvmExtensionsKt;
import kotlin.metadata.jvm.JvmFieldSignature;
import kotlin.metadata.jvm.JvmMetadataUtil;
import kotlin.metadata.jvm.JvmMethodSignature;
import kotlin.metadata.jvm.KotlinClassMetadata;
import proguard.classfile.Clazz;
import proguard.classfile.FieldSignature;
import proguard.classfile.LibraryClass;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinContractMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinEffectExpressionMetadata;
import proguard.classfile.kotlin.KotlinEffectInvocationKind;
import proguard.classfile.kotlin.KotlinEffectMetadata;
import proguard.classfile.kotlin.KotlinEffectType;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMetadataVersion;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinTypeVariance;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementLevel;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementVersionKind;
import proguard.classfile.kotlin.UnsupportedKotlinMetadata;
import proguard.classfile.kotlin.flags.KotlinClassFlags;
import proguard.classfile.kotlin.flags.KotlinConstructorFlags;
import proguard.classfile.kotlin.flags.KotlinEffectExpressionFlags;
import proguard.classfile.kotlin.flags.KotlinFunctionFlags;
import proguard.classfile.kotlin.flags.KotlinModalityFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyAccessorFlags;
import proguard.classfile.kotlin.flags.KotlinPropertyFlags;
import proguard.classfile.kotlin.flags.KotlinTypeAliasFlags;
import proguard.classfile.kotlin.flags.KotlinTypeFlags;
import proguard.classfile.kotlin.flags.KotlinTypeParameterFlags;
import proguard.classfile.kotlin.flags.KotlinValueParameterFlags;
import proguard.classfile.kotlin.flags.KotlinVisibilityFlags;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.util.kotlin.KotlinAnnotationUtilKt;
import proguard.classfile.util.kotlin.KotlinMetadataType;
import proguard.classfile.visitor.ClassVisitor;

public class KotlinMetadataInitializer
implements ClassVisitor,
AnnotationVisitor,
ElementValueVisitor,
ConstantVisitor {
    private int k;
    private int[] mv;
    private String[] d1;
    private String[] d2;
    private int xi;
    private String xs;
    private String pn;
    private final BiConsumer<Clazz, String> errorHandler;
    private KotlinMetadataType currentType;

    public KotlinMetadataInitializer(WarningPrinter warningPrinter) {
        this((Clazz clazz, String message) -> warningPrinter.print(clazz.getName(), (String)message));
    }

    public KotlinMetadataInitializer(BiConsumer<Clazz, String> errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramClass(ProgramClass clazz) {
        clazz.accept(new AllAttributeVisitor(new AttributeNameFilter("RuntimeVisibleAnnotations", (AttributeVisitor)new AllAnnotationVisitor(new AnnotationTypeFilter("Lkotlin/Metadata;", (AnnotationVisitor)this)))));
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        this.k = -1;
        this.mv = null;
        this.d1 = null;
        this.d2 = null;
        this.xi = 0;
        this.xs = null;
        this.pn = null;
        try {
            annotation.elementValuesAccept(clazz, this);
        }
        catch (Exception e) {
            this.errorHandler.accept(clazz, "Encountered corrupt Kotlin metadata in class " + clazz.getName() + ". The metadata for this class will not be processed (" + e.getMessage() + ")");
            clazz.accept(new SimpleKotlinMetadataSetter(new UnsupportedKotlinMetadata(this.k, this.mv, this.xi, this.xs, this.pn)));
            return;
        }
        this.initialize(clazz, this.k, this.mv, this.d1, this.d2, this.xi, this.xs, this.pn);
    }

    public void initialize(Clazz clazz, int k, int[] mv, String[] d1, String[] d2, int xi, String xs, String pn) {
        KotlinClassMetadata md;
        Metadata metadata = JvmMetadataUtil.Metadata(k, mv, d1, d2, xs, pn, xi);
        try {
            md = KotlinClassMetadata.readStrict(metadata);
        }
        catch (IllegalArgumentException e) {
            String version = mv == null ? "unknown" : Arrays.stream(mv).mapToObj(Integer::toString).collect(Collectors.joining("."));
            this.errorHandler.accept(clazz, "Encountered corrupt @kotlin/Metadata for class " + clazz.getName() + " (version " + version + ").");
            clazz.accept(new SimpleKotlinMetadataSetter(new UnsupportedKotlinMetadata(k, mv, xi, xs, pn)));
            return;
        }
        try {
            switch (k) {
                case 1: {
                    KotlinClassKindMetadata kotlinClassKindMetadata = this.convertClassKindMetadata(metadata, md);
                    kotlinClassKindMetadata.ownerClassName = clazz.getName();
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinClassKindMetadata));
                    break;
                }
                case 2: {
                    KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata = KotlinMetadataInitializer.convertFileFacadeKindMetadata(metadata, md);
                    kotlinFileFacadeKindMetadata.ownerClassName = clazz.getName();
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinFileFacadeKindMetadata));
                    break;
                }
                case 3: {
                    KotlinClassMetadata.SyntheticClass smd = (KotlinClassMetadata.SyntheticClass)md;
                    KotlinSyntheticClassKindMetadata.Flavor flavor = smd.isLambda() ? KotlinSyntheticClassKindMetadata.Flavor.LAMBDA : (clazz.getName().endsWith("$DefaultImpls") ? KotlinSyntheticClassKindMetadata.Flavor.DEFAULT_IMPLS : (clazz.getName().endsWith("$WhenMappings") ? KotlinSyntheticClassKindMetadata.Flavor.WHEN_MAPPINGS : KotlinSyntheticClassKindMetadata.Flavor.REGULAR));
                    KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata = new KotlinSyntheticClassKindMetadata(mv, xi, xs, pn, flavor);
                    if (smd.isLambda()) {
                        kotlinSyntheticClassKindMetadata.functions = new ArrayList<KotlinFunctionMetadata>(1);
                        kotlinSyntheticClassKindMetadata.functions.add(KotlinMetadataInitializer.convertKmFunction(Objects.requireNonNull(smd.getKmLambda()).getFunction()));
                    } else {
                        kotlinSyntheticClassKindMetadata.functions = Collections.emptyList();
                    }
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinSyntheticClassKindMetadata));
                    break;
                }
                case 4: {
                    clazz.accept(new SimpleKotlinMetadataSetter(new KotlinMultiFileFacadeKindMetadata(mv, d1, xi, xs, pn)));
                    break;
                }
                case 5: {
                    KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata = KotlinMetadataInitializer.convertMultiFilePartKindMetadata(metadata, md);
                    kotlinMultiFilePartKindMetadata.ownerClassName = clazz.getName();
                    clazz.accept(new SimpleKotlinMetadataSetter(kotlinMultiFilePartKindMetadata));
                    break;
                }
                default: {
                    this.errorHandler.accept(clazz, "Unknown Kotlin class kind in class " + clazz.getName() + ". The metadata for this class will not be processed.");
                    clazz.accept(new SimpleKotlinMetadataSetter(new UnsupportedKotlinMetadata(k, mv, xi, xs, pn)));
                    break;
                }
            }
        }
        catch (InconsistentKotlinMetadataException e) {
            this.errorHandler.accept(clazz, "Encountered corrupt Kotlin metadata in class " + clazz.getName() + ". The metadata for this class will not be processed (" + e.getMessage() + ")");
            clazz.accept(new SimpleKotlinMetadataSetter(new UnsupportedKotlinMetadata(k, mv, xi, xs, pn)));
        }
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.currentType = KotlinMetadataInitializer.metadataTypeOf(constantElementValue.getMethodName(clazz));
        clazz.constantPoolEntryAccept(constantElementValue.u2constantValueIndex, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        KotlinMetadataType arrayElementType = KotlinMetadataInitializer.metadataTypeOf(arrayElementValue.getMethodName(clazz));
        switch (arrayElementType) {
            case mv: {
                this.mv = new int[arrayElementValue.u2elementValuesCount];
                break;
            }
            case d1: {
                this.d1 = new String[arrayElementValue.u2elementValuesCount];
                break;
            }
            case d2: {
                this.d2 = new String[arrayElementValue.u2elementValuesCount];
                break;
            }
        }
        arrayElementValue.elementValuesAccept(clazz, annotation, new ArrayElementValueCollector(arrayElementType));
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        if (this.currentType == KotlinMetadataType.xs) {
            this.xs = utf8Constant.getString();
        } else if (this.currentType == KotlinMetadataType.pn) {
            this.pn = utf8Constant.getString();
        } else {
            throw new UnsupportedOperationException("Cannot store Utf8Constant in int");
        }
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        if (this.currentType == KotlinMetadataType.k) {
            this.k = integerConstant.getValue();
        } else if (this.currentType == KotlinMetadataType.xi) {
            this.xi = integerConstant.getValue();
        } else {
            throw new UnsupportedOperationException("Cannot store Utf8Constant in int");
        }
    }

    private KotlinClassKindMetadata convertClassKindMetadata(Metadata metadata, KotlinClassMetadata md) {
        KotlinClassKindMetadata kotlinClassKindMetadata = new KotlinClassKindMetadata(metadata.mv(), metadata.xi(), metadata.xs(), metadata.pn());
        KotlinClassMetadata.Class classMetadata = (KotlinClassMetadata.Class)md;
        KmClass kmClass = classMetadata.getKmClass();
        String className = kmClass.getName();
        if (className.startsWith(".")) {
            className = className.substring(1);
        }
        kotlinClassKindMetadata.className = className = className.replace('.', '$');
        kotlinClassKindMetadata.flags = KotlinMetadataInitializer.convertClassFlags(kmClass);
        kotlinClassKindMetadata.companionObjectName = kmClass.getCompanionObject();
        kotlinClassKindMetadata.underlyingPropertyName = kmClass.getInlineClassUnderlyingPropertyName();
        kotlinClassKindMetadata.underlyingPropertyType = KotlinMetadataInitializer.convertKmType(kmClass.getInlineClassUnderlyingType());
        kotlinClassKindMetadata.enumEntryNames = kmClass.getEnumEntries();
        kotlinClassKindMetadata.nestedClassNames = kmClass.getNestedClasses();
        kotlinClassKindMetadata.sealedSubclassNames = kmClass.getSealedSubclasses().stream().map(it -> it.replace(".", "$")).collect(Collectors.toList());
        kotlinClassKindMetadata.versionRequirement = KotlinMetadataInitializer.convertKmVersionRequirement(kmClass.getVersionRequirements());
        kotlinClassKindMetadata.typeParameters = kmClass.getTypeParameters().stream().map(KotlinMetadataInitializer::convertKmTypeParameter).collect(Collectors.toList());
        kotlinClassKindMetadata.contextReceivers = kmClass.getContextReceiverTypes().stream().map(KotlinMetadataInitializer::convertKmType).collect(Collectors.toList());
        kotlinClassKindMetadata.superTypes = kmClass.getSupertypes().stream().map(KotlinMetadataInitializer::convertKmType).collect(Collectors.toList());
        kotlinClassKindMetadata.constructors = kmClass.getConstructors().stream().map(it -> KotlinMetadataInitializer.convertKmConstructor(kotlinClassKindMetadata.flags.isAnnotationClass, it)).collect(Collectors.toList());
        kotlinClassKindMetadata.functions = kmClass.getFunctions().stream().map(KotlinMetadataInitializer::convertKmFunction).collect(Collectors.toList());
        kotlinClassKindMetadata.properties = kmClass.getProperties().stream().map(KotlinMetadataInitializer::convertKmProperty).collect(Collectors.toList());
        kotlinClassKindMetadata.typeAliases = kmClass.getTypeAliases().stream().map(KotlinMetadataInitializer::convertKmTypeAlias).collect(Collectors.toList());
        kotlinClassKindMetadata.flags.hasMethodBodiesInInterface = JvmAttributes.getHasMethodBodiesInInterface(kmClass);
        kotlinClassKindMetadata.flags.isCompiledInCompatibilityMode = JvmAttributes.isCompiledInCompatibilityMode(kmClass);
        kotlinClassKindMetadata.anonymousObjectOriginName = JvmExtensionsKt.getAnonymousObjectOriginName(kmClass);
        kotlinClassKindMetadata.localDelegatedProperties = JvmExtensionsKt.getLocalDelegatedProperties(kmClass).stream().map(KotlinMetadataInitializer::convertKmProperty).collect(Collectors.toList());
        return kotlinClassKindMetadata;
    }

    private static KotlinFileFacadeKindMetadata convertFileFacadeKindMetadata(Metadata metadata, KotlinClassMetadata md) {
        KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata = new KotlinFileFacadeKindMetadata(metadata.mv(), metadata.xi(), metadata.xs(), metadata.pn());
        KotlinClassMetadata.FileFacade fileFacade = (KotlinClassMetadata.FileFacade)md;
        KmPackage kmPackage = fileFacade.getKmPackage();
        KotlinMetadataInitializer.populateFromKmPackage(kotlinFileFacadeKindMetadata, kmPackage);
        return kotlinFileFacadeKindMetadata;
    }

    private static KotlinMultiFilePartKindMetadata convertMultiFilePartKindMetadata(Metadata metadata, KotlinClassMetadata md) {
        KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata = new KotlinMultiFilePartKindMetadata(metadata.mv(), metadata.xi(), metadata.xs(), metadata.pn());
        KotlinClassMetadata.MultiFileClassPart fileFacade = (KotlinClassMetadata.MultiFileClassPart)md;
        KmPackage kmPackage = fileFacade.getKmPackage();
        KotlinMetadataInitializer.populateFromKmPackage(kotlinMultiFilePartKindMetadata, kmPackage);
        return kotlinMultiFilePartKindMetadata;
    }

    private static KotlinFunctionMetadata convertKmFunction(KmFunction kmFunction) {
        KotlinFunctionMetadata kotlinFunctionMetadata = new KotlinFunctionMetadata(KotlinMetadataInitializer.convertFunctionFlags(kmFunction), kmFunction.getName());
        kotlinFunctionMetadata.contracts = kmFunction.getContract() != null ? new ArrayList<KotlinContractMetadata>(Collections.singleton(KotlinMetadataInitializer.convertKmContract(kmFunction.getContract()))) : new ArrayList();
        kotlinFunctionMetadata.receiverType = KotlinMetadataInitializer.convertKmType(kmFunction.getReceiverParameterType());
        kotlinFunctionMetadata.contextReceivers = kmFunction.getContextReceiverTypes().stream().map(KotlinMetadataInitializer::convertKmType).collect(Collectors.toList());
        kotlinFunctionMetadata.returnType = KotlinMetadataInitializer.convertKmType(kmFunction.returnType);
        kotlinFunctionMetadata.typeParameters = kmFunction.getTypeParameters().stream().map(KotlinMetadataInitializer::convertKmTypeParameter).collect(Collectors.toList());
        List<KmValueParameter> valueParameters = kmFunction.getValueParameters();
        kotlinFunctionMetadata.valueParameters = new ArrayList<KotlinValueParameterMetadata>(valueParameters.size());
        for (int i = 0; i < valueParameters.size(); ++i) {
            kotlinFunctionMetadata.valueParameters.add(KotlinMetadataInitializer.convertKmValueParameter(i, valueParameters.get(i)));
        }
        kotlinFunctionMetadata.versionRequirement = KotlinMetadataInitializer.convertKmVersionRequirement(kmFunction.getVersionRequirements());
        kotlinFunctionMetadata.jvmSignature = KotlinMetadataInitializer.convertJvmMethodSignature(JvmExtensionsKt.getSignature(kmFunction));
        kotlinFunctionMetadata.lambdaClassOriginName = JvmExtensionsKt.getLambdaClassOriginName(kmFunction);
        return kotlinFunctionMetadata;
    }

    private static KotlinContractMetadata convertKmContract(KmContract kmContract) {
        KotlinContractMetadata kotlinContractMetadata = new KotlinContractMetadata();
        kotlinContractMetadata.effects = kmContract.getEffects().stream().map(KotlinMetadataInitializer::convertKmEffect).collect(Collectors.toList());
        return kotlinContractMetadata;
    }

    private static KotlinEffectMetadata convertKmEffect(KmEffect kmEffect) {
        KotlinEffectMetadata effect = new KotlinEffectMetadata(KotlinMetadataInitializer.convertKmEffectType(kmEffect.getType()), KotlinMetadataInitializer.convertKmEffectInvocationKind(kmEffect.getInvocationKind()));
        effect.conclusionOfConditionalEffect = KotlinMetadataInitializer.convertKmEffectExpression(kmEffect.getConclusion());
        effect.constructorArguments = kmEffect.getConstructorArguments().stream().map(KotlinMetadataInitializer::convertKmEffectExpression).collect(Collectors.toList());
        return effect;
    }

    private static KotlinEffectExpressionMetadata convertKmEffectExpression(KmEffectExpression kmEffectExpression) {
        if (kmEffectExpression == null) {
            return null;
        }
        KotlinEffectExpressionMetadata expressionMetadata = new KotlinEffectExpressionMetadata();
        expressionMetadata.flags = KotlinMetadataInitializer.convertEffectExpressionFlags(kmEffectExpression);
        if (kmEffectExpression.getParameterIndex() != null) {
            expressionMetadata.parameterIndex = kmEffectExpression.getParameterIndex();
        }
        if (kmEffectExpression.getConstantValue() != null) {
            expressionMetadata.hasConstantValue = true;
            expressionMetadata.constantValue = kmEffectExpression.getConstantValue().getValue();
        }
        if (kmEffectExpression.isInstanceType() != null) {
            expressionMetadata.typeOfIs = KotlinMetadataInitializer.convertKmType(kmEffectExpression.isInstanceType());
        }
        expressionMetadata.andRightHandSides = kmEffectExpression.getAndArguments().stream().map(KotlinMetadataInitializer::convertKmEffectExpression).collect(Collectors.toList());
        expressionMetadata.orRightHandSides = kmEffectExpression.getOrArguments().stream().map(KotlinMetadataInitializer::convertKmEffectExpression).collect(Collectors.toList());
        return expressionMetadata;
    }

    private static KotlinTypeAliasMetadata convertKmTypeAlias(KmTypeAlias kmTypeAlias) {
        KotlinTypeAliasMetadata typeAlias = new KotlinTypeAliasMetadata(KotlinMetadataInitializer.convertTypeAliasFlags(kmTypeAlias), kmTypeAlias.getName());
        typeAlias.underlyingType = KotlinMetadataInitializer.convertKmType(kmTypeAlias.getUnderlyingType());
        typeAlias.expandedType = KotlinMetadataInitializer.convertKmType(kmTypeAlias.getExpandedType());
        typeAlias.versionRequirement = KotlinMetadataInitializer.convertKmVersionRequirement(kmTypeAlias.getVersionRequirements());
        typeAlias.annotations = kmTypeAlias.getAnnotations().stream().map(KotlinAnnotationUtilKt::convertAnnotation).collect(Collectors.toList());
        typeAlias.typeParameters = kmTypeAlias.getTypeParameters().stream().map(KotlinMetadataInitializer::convertKmTypeParameter).collect(Collectors.toList());
        return typeAlias;
    }

    private static KotlinPropertyMetadata convertKmProperty(KmProperty kmProperty) {
        KotlinPropertyAccessorFlags setterFlags = kmProperty.getSetter() != null ? KotlinMetadataInitializer.convertPropertyAccessorFlags(kmProperty.getSetter()) : null;
        KotlinPropertyMetadata property = new KotlinPropertyMetadata(KotlinMetadataInitializer.convertPropertyFlags(kmProperty), kmProperty.getName(), KotlinMetadataInitializer.convertPropertyAccessorFlags(kmProperty.getGetter()), setterFlags);
        property.receiverType = KotlinMetadataInitializer.convertKmType(kmProperty.getReceiverParameterType());
        property.contextReceivers = kmProperty.getContextReceiverTypes().stream().map(KotlinMetadataInitializer::convertKmType).collect(Collectors.toList());
        property.type = KotlinMetadataInitializer.convertKmType(kmProperty.returnType);
        property.versionRequirement = KotlinMetadataInitializer.convertKmVersionRequirement(kmProperty.getVersionRequirements());
        KmValueParameter setterParameter = kmProperty.getSetterParameter();
        property.setterParameters = setterParameter != null ? new ArrayList<KotlinValueParameterMetadata>(Collections.singletonList(KotlinMetadataInitializer.convertKmValueParameter(0, setterParameter))) : new ArrayList();
        property.typeParameters = kmProperty.getTypeParameters().stream().map(KotlinMetadataInitializer::convertKmTypeParameter).collect(Collectors.toList());
        property.backingFieldSignature = KotlinMetadataInitializer.convertJvmFieldSignature(JvmExtensionsKt.getFieldSignature(kmProperty));
        property.getterSignature = KotlinMetadataInitializer.convertJvmMethodSignature(JvmExtensionsKt.getGetterSignature(kmProperty));
        property.setterSignature = KotlinMetadataInitializer.convertJvmMethodSignature(JvmExtensionsKt.getSetterSignature(kmProperty));
        property.flags.isMovedFromInterfaceCompanion = JvmAttributes.isMovedFromInterfaceCompanion(kmProperty);
        property.syntheticMethodForAnnotations = KotlinMetadataInitializer.convertJvmMethodSignature(JvmExtensionsKt.getSyntheticMethodForAnnotations(kmProperty));
        property.syntheticMethodForDelegate = KotlinMetadataInitializer.convertJvmMethodSignature(JvmExtensionsKt.getSyntheticMethodForDelegate(kmProperty));
        return property;
    }

    private static KotlinTypeMetadata convertKmType(KmType kmType) {
        return KotlinMetadataInitializer.convertKmType(kmType, null);
    }

    private static KotlinTypeMetadata convertKmType(KmType kmType, KmVariance kmVariance) {
        KmClassifier classifier;
        if (kmType == null) {
            return null;
        }
        KotlinTypeMetadata type = new KotlinTypeMetadata(KotlinMetadataInitializer.convertTypeFlags(kmType), KotlinMetadataInitializer.convertKmVariance(kmVariance));
        type.abbreviation = KotlinMetadataInitializer.convertKmType(kmType.getAbbreviatedType(), null);
        if (kmType.getClassifier() instanceof KmClassifier.Class) {
            classifier = (KmClassifier.Class)kmType.getClassifier();
            String className = ((KmClassifier.Class)classifier).getName();
            if (ClassUtil.isInternalClassType(className)) {
                className = ClassUtil.internalClassNameFromClassType(className);
            }
            if (className.startsWith(".")) {
                className = className.substring(1);
            }
            type.className = className = className.replace('.', '$');
        } else if (kmType.getClassifier() instanceof KmClassifier.TypeParameter) {
            classifier = (KmClassifier.TypeParameter)kmType.getClassifier();
            type.typeParamID = ((KmClassifier.TypeParameter)classifier).getId();
        } else if (kmType.getClassifier() instanceof KmClassifier.TypeAlias) {
            classifier = (KmClassifier.TypeAlias)kmType.getClassifier();
            type.aliasName = ((KmClassifier.TypeAlias)classifier).getName();
        }
        type.outerClassType = KotlinMetadataInitializer.convertKmType(kmType.getOuterType());
        type.typeArguments = kmType.getArguments().stream().map(KotlinMetadataInitializer::convertKmTypeProjection).collect(Collectors.toList());
        KmFlexibleTypeUpperBound flexibleTypeUpperBound = kmType.getFlexibleTypeUpperBound();
        if (flexibleTypeUpperBound != null) {
            type.flexibilityID = flexibleTypeUpperBound.getTypeFlexibilityId();
            type.upperBounds = new ArrayList<KotlinTypeMetadata>(Collections.singletonList(KotlinMetadataInitializer.convertKmType(flexibleTypeUpperBound.getType())));
        } else {
            type.upperBounds = new ArrayList<KotlinTypeMetadata>();
        }
        type.isRaw = JvmExtensionsKt.isRaw(kmType);
        type.annotations = JvmExtensionsKt.getAnnotations(kmType).stream().map(KotlinAnnotationUtilKt::convertAnnotation).collect(Collectors.toList());
        return type;
    }

    private static KotlinTypeMetadata convertKmTypeProjection(KmTypeProjection kmTypeProjection) {
        if (kmTypeProjection == KmTypeProjection.STAR) {
            return KotlinTypeMetadata.starProjection();
        }
        return KotlinMetadataInitializer.convertKmType(kmTypeProjection.getType(), kmTypeProjection.getVariance());
    }

    private static KotlinTypeParameterMetadata convertKmTypeParameter(KmTypeParameter kmTypeParameter) {
        KotlinTypeParameterMetadata kotlinTypeParameterMetadata = new KotlinTypeParameterMetadata(KotlinMetadataInitializer.convertTypeParameterFlags(kmTypeParameter), kmTypeParameter.getName(), kmTypeParameter.getId(), KotlinMetadataInitializer.convertKmVariance(kmTypeParameter.getVariance()));
        kotlinTypeParameterMetadata.upperBounds = kmTypeParameter.getUpperBounds().stream().map(KotlinMetadataInitializer::convertKmType).collect(Collectors.toList());
        kotlinTypeParameterMetadata.annotations = JvmExtensionsKt.getAnnotations(kmTypeParameter).stream().map(KotlinAnnotationUtilKt::convertAnnotation).collect(Collectors.toList());
        return kotlinTypeParameterMetadata;
    }

    private static KotlinConstructorMetadata convertKmConstructor(boolean isAnnotationClass, KmConstructor kmConstructor) {
        KotlinConstructorMetadata constructor = new KotlinConstructorMetadata(KotlinMetadataInitializer.convertConstructorFlags(kmConstructor));
        List<KmValueParameter> valueParameters = kmConstructor.getValueParameters();
        constructor.valueParameters = new ArrayList<KotlinValueParameterMetadata>(valueParameters.size());
        for (int i = 0; i < valueParameters.size(); ++i) {
            constructor.valueParameters.add(KotlinMetadataInitializer.convertKmValueParameter(i, valueParameters.get(i)));
        }
        constructor.versionRequirement = KotlinMetadataInitializer.convertKmVersionRequirement(kmConstructor.getVersionRequirements());
        if (!isAnnotationClass) {
            constructor.jvmSignature = KotlinMetadataInitializer.convertJvmMethodSignature(JvmExtensionsKt.getSignature(kmConstructor));
        }
        return constructor;
    }

    private static KotlinValueParameterMetadata convertKmValueParameter(int index, KmValueParameter kmValueParameter) {
        KotlinValueParameterMetadata valueParameterMetadata = new KotlinValueParameterMetadata(KotlinMetadataInitializer.convertValueParameterFlags(kmValueParameter), index, kmValueParameter.getName());
        valueParameterMetadata.type = KotlinMetadataInitializer.convertKmType(kmValueParameter.getType());
        valueParameterMetadata.varArgElementType = KotlinMetadataInitializer.convertKmType(kmValueParameter.getVarargElementType());
        return valueParameterMetadata;
    }

    private static KotlinVersionRequirementMetadata convertKmVersionRequirement(List<KmVersionRequirement> kmVersionRequirement) {
        List versionRequirementMetadata = kmVersionRequirement.stream().map(KotlinMetadataInitializer::convertKmVersionRequirement).collect(Collectors.toList());
        if (versionRequirementMetadata.size() > 1) {
            return (KotlinVersionRequirementMetadata)versionRequirementMetadata.get(versionRequirementMetadata.size() - 1);
        }
        if (versionRequirementMetadata.size() == 1) {
            return (KotlinVersionRequirementMetadata)versionRequirementMetadata.get(0);
        }
        return null;
    }

    private static KotlinVersionRequirementMetadata convertKmVersionRequirement(KmVersionRequirement kmVersionRequirement) {
        KotlinVersionRequirementMetadata versionReq = new KotlinVersionRequirementMetadata();
        switch (kmVersionRequirement.kind) {
            case API_VERSION: {
                versionReq.kind = KotlinVersionRequirementVersionKind.API_VERSION;
                break;
            }
            case COMPILER_VERSION: {
                versionReq.kind = KotlinVersionRequirementVersionKind.COMPILER_VERSION;
                break;
            }
            case LANGUAGE_VERSION: {
                versionReq.kind = KotlinVersionRequirementVersionKind.LANGUAGE_VERSION;
                break;
            }
            case UNKNOWN: {
                versionReq.kind = KotlinVersionRequirementVersionKind.UNKNOWN;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Encountered unknown enum value for KmVersionRequirementVersionKind.");
            }
        }
        switch (kmVersionRequirement.level) {
            case ERROR: {
                versionReq.level = KotlinVersionRequirementLevel.ERROR;
                break;
            }
            case HIDDEN: {
                versionReq.level = KotlinVersionRequirementLevel.HIDDEN;
                break;
            }
            case WARNING: {
                versionReq.level = KotlinVersionRequirementLevel.WARNING;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Encountered unknown enum value for KmVersionRequirementLevel.");
            }
        }
        versionReq.errorCode = kmVersionRequirement.getErrorCode();
        versionReq.message = kmVersionRequirement.getMessage();
        versionReq.major = kmVersionRequirement.version.getMajor();
        versionReq.minor = kmVersionRequirement.version.getMinor();
        versionReq.patch = kmVersionRequirement.version.getPatch();
        return versionReq;
    }

    private static MethodSignature convertJvmMethodSignature(JvmMethodSignature jvmMethodSignature) {
        if (jvmMethodSignature == null) {
            return null;
        }
        try {
            return new MethodSignature(null, jvmMethodSignature.getName(), jvmMethodSignature.getDescriptor());
        }
        catch (Exception e) {
            return null;
        }
    }

    private static FieldSignature convertJvmFieldSignature(JvmFieldSignature jvmFieldSignature) {
        if (jvmFieldSignature == null) {
            return null;
        }
        return new FieldSignature(null, jvmFieldSignature.getName(), jvmFieldSignature.getDescriptor());
    }

    private static KotlinTypeVariance convertKmVariance(KmVariance variance) {
        if (variance == null) {
            return null;
        }
        switch (variance) {
            case IN: {
                return KotlinTypeVariance.IN;
            }
            case INVARIANT: {
                return KotlinTypeVariance.INVARIANT;
            }
            case OUT: {
                return KotlinTypeVariance.OUT;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmVariance.");
    }

    private static KotlinEffectType convertKmEffectType(KmEffectType effectType) {
        switch (effectType) {
            case CALLS: {
                return KotlinEffectType.CALLS;
            }
            case RETURNS_CONSTANT: {
                return KotlinEffectType.RETURNS_CONSTANT;
            }
            case RETURNS_NOT_NULL: {
                return KotlinEffectType.RETURNS_NOT_NULL;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmEffectType.");
    }

    private static KotlinEffectInvocationKind convertKmEffectInvocationKind(KmEffectInvocationKind invocationKind) {
        if (invocationKind == null) {
            return null;
        }
        switch (invocationKind) {
            case AT_MOST_ONCE: {
                return KotlinEffectInvocationKind.AT_MOST_ONCE;
            }
            case EXACTLY_ONCE: {
                return KotlinEffectInvocationKind.EXACTLY_ONCE;
            }
            case AT_LEAST_ONCE: {
                return KotlinEffectInvocationKind.AT_LEAST_ONCE;
            }
        }
        throw new UnsupportedOperationException("Encountered unknown enum value for KmEffectInvocationKind.");
    }

    private static KotlinVisibilityFlags convertVisibilityFlags(Visibility visibility2) {
        KotlinVisibilityFlags flags = new KotlinVisibilityFlags();
        flags.isInternal = visibility2 == Visibility.INTERNAL;
        flags.isLocal = visibility2 == Visibility.LOCAL;
        flags.isPrivate = visibility2 == Visibility.PRIVATE;
        flags.isProtected = visibility2 == Visibility.PROTECTED;
        flags.isPublic = visibility2 == Visibility.PUBLIC;
        flags.isPrivateToThis = visibility2 == Visibility.PRIVATE_TO_THIS;
        return flags;
    }

    private static KotlinModalityFlags convertModalityFlags(Modality modality2) {
        KotlinModalityFlags flags = new KotlinModalityFlags();
        flags.isAbstract = modality2 == Modality.ABSTRACT;
        flags.isFinal = modality2 == Modality.FINAL;
        flags.isOpen = modality2 == Modality.OPEN;
        flags.isSealed = modality2 == Modality.SEALED;
        return flags;
    }

    private static KotlinClassFlags convertClassFlags(KmClass kmClass) {
        KotlinClassFlags flags = new KotlinClassFlags(KotlinMetadataInitializer.convertVisibilityFlags(Attributes.getVisibility(kmClass)), KotlinMetadataInitializer.convertModalityFlags(Attributes.getModality(kmClass)));
        flags.isUsualClass = Attributes.getKind(kmClass) == ClassKind.CLASS;
        flags.isInterface = Attributes.getKind(kmClass) == ClassKind.INTERFACE;
        flags.isEnumClass = Attributes.getKind(kmClass) == ClassKind.ENUM_CLASS;
        flags.isEnumEntry = Attributes.getKind(kmClass) == ClassKind.ENUM_ENTRY;
        flags.isAnnotationClass = Attributes.getKind(kmClass) == ClassKind.ANNOTATION_CLASS;
        flags.isObject = Attributes.getKind(kmClass) == ClassKind.OBJECT;
        flags.isCompanionObject = Attributes.getKind(kmClass) == ClassKind.COMPANION_OBJECT;
        flags.hasAnnotations = Attributes.getHasAnnotations(kmClass);
        flags.isInner = Attributes.isInner(kmClass);
        flags.isData = Attributes.isData(kmClass);
        flags.isExternal = Attributes.isExternal(kmClass);
        flags.isExpect = Attributes.isExpect(kmClass);
        flags.isValue = Attributes.isValue(kmClass);
        flags.isFun = Attributes.isFunInterface(kmClass);
        return flags;
    }

    private static KotlinConstructorFlags convertConstructorFlags(KmConstructor kmConstructor) {
        KotlinConstructorFlags flags = new KotlinConstructorFlags(KotlinMetadataInitializer.convertVisibilityFlags(Attributes.getVisibility(kmConstructor)));
        flags.hasAnnotations = Attributes.getHasAnnotations(kmConstructor);
        flags.hasNonStableParameterNames = Attributes.getHasNonStableParameterNames(kmConstructor);
        flags.isSecondary = Attributes.isSecondary(kmConstructor);
        return flags;
    }

    private static KotlinFunctionFlags convertFunctionFlags(KmFunction kmFunction) {
        KotlinFunctionFlags flags = new KotlinFunctionFlags(KotlinMetadataInitializer.convertVisibilityFlags(Attributes.getVisibility(kmFunction)), KotlinMetadataInitializer.convertModalityFlags(Attributes.getModality(kmFunction)));
        flags.isDeclaration = Attributes.getKind(kmFunction) == MemberKind.DECLARATION;
        flags.isFakeOverride = Attributes.getKind(kmFunction) == MemberKind.FAKE_OVERRIDE;
        flags.isDelegation = Attributes.getKind(kmFunction) == MemberKind.DELEGATION;
        flags.isSynthesized = Attributes.getKind(kmFunction) == MemberKind.SYNTHESIZED;
        flags.hasAnnotations = Attributes.getHasAnnotations(kmFunction);
        flags.isOperator = Attributes.isOperator(kmFunction);
        flags.isInfix = Attributes.isInfix(kmFunction);
        flags.isInline = Attributes.isInline(kmFunction);
        flags.isTailrec = Attributes.isTailrec(kmFunction);
        flags.isExternal = Attributes.isExternal(kmFunction);
        flags.isSuspend = Attributes.isSuspend(kmFunction);
        flags.isExpect = Attributes.isExpect(kmFunction);
        return flags;
    }

    private static KotlinTypeFlags convertTypeFlags(KmType kmType) {
        KotlinTypeFlags flags = new KotlinTypeFlags();
        flags.isNullable = Attributes.isNullable(kmType);
        flags.isSuspend = Attributes.isSuspend(kmType);
        flags.isDefinitelyNonNull = Attributes.isDefinitelyNonNull(kmType);
        return flags;
    }

    private static KotlinTypeParameterFlags convertTypeParameterFlags(KmTypeParameter kmTypeParameter) {
        KotlinTypeParameterFlags flags = new KotlinTypeParameterFlags();
        flags.isReified = Attributes.isReified(kmTypeParameter);
        return flags;
    }

    private static KotlinTypeAliasFlags convertTypeAliasFlags(KmTypeAlias kmTypeAlias) {
        KotlinTypeAliasFlags flags = new KotlinTypeAliasFlags(KotlinMetadataInitializer.convertVisibilityFlags(Attributes.getVisibility(kmTypeAlias)));
        flags.hasAnnotations = Attributes.getHasAnnotations(kmTypeAlias);
        return flags;
    }

    private static KotlinPropertyFlags convertPropertyFlags(KmProperty kmProperty) {
        KotlinPropertyFlags flags = new KotlinPropertyFlags(KotlinMetadataInitializer.convertVisibilityFlags(Attributes.getVisibility(kmProperty)), KotlinMetadataInitializer.convertModalityFlags(Attributes.getModality(kmProperty)));
        flags.isDeclared = Attributes.getKind(kmProperty) == MemberKind.DECLARATION;
        flags.isFakeOverride = Attributes.getKind(kmProperty) == MemberKind.FAKE_OVERRIDE;
        flags.isDelegation = Attributes.getKind(kmProperty) == MemberKind.DELEGATION;
        flags.isSynthesized = Attributes.getKind(kmProperty) == MemberKind.SYNTHESIZED;
        flags.hasAnnotations = Attributes.getHasAnnotations(kmProperty);
        flags.isVar = Attributes.isVar(kmProperty);
        flags.isConst = Attributes.isConst(kmProperty);
        flags.isLateinit = Attributes.isLateinit(kmProperty);
        flags.hasConstant = Attributes.getHasConstant(kmProperty);
        flags.isExternal = Attributes.isExternal(kmProperty);
        flags.isDelegated = Attributes.isDelegated(kmProperty);
        flags.isExpect = Attributes.isExpect(kmProperty);
        return flags;
    }

    private static KotlinPropertyAccessorFlags convertPropertyAccessorFlags(KmPropertyAccessorAttributes kmPropertyAccessorAttributes) {
        KotlinPropertyAccessorFlags flags = new KotlinPropertyAccessorFlags(KotlinMetadataInitializer.convertVisibilityFlags(Attributes.getVisibility(kmPropertyAccessorAttributes)), KotlinMetadataInitializer.convertModalityFlags(Attributes.getModality(kmPropertyAccessorAttributes)));
        flags.hasAnnotations = Attributes.getHasAnnotations(kmPropertyAccessorAttributes);
        flags.isDefault = !Attributes.isNotDefault(kmPropertyAccessorAttributes);
        flags.isExternal = Attributes.isExternal(kmPropertyAccessorAttributes);
        flags.isInline = Attributes.isInline(kmPropertyAccessorAttributes);
        return flags;
    }

    private static KotlinValueParameterFlags convertValueParameterFlags(KmValueParameter kmValueParameter) {
        KotlinValueParameterFlags flags = new KotlinValueParameterFlags();
        flags.hasAnnotations = Attributes.getHasAnnotations(kmValueParameter);
        flags.hasDefaultValue = Attributes.getDeclaresDefaultValue(kmValueParameter);
        flags.isCrossInline = Attributes.isCrossinline(kmValueParameter);
        flags.isNoInline = Attributes.isNoinline(kmValueParameter);
        return flags;
    }

    private static KotlinEffectExpressionFlags convertEffectExpressionFlags(KmEffectExpression kmEffectExpression) {
        KotlinEffectExpressionFlags flags = new KotlinEffectExpressionFlags();
        flags.isNullCheckPredicate = Attributes.isNullCheckPredicate(kmEffectExpression);
        flags.isNegated = Attributes.isNegated(kmEffectExpression);
        return flags;
    }

    private static void populateFromKmPackage(KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KmPackage kmPackage) {
        kotlinDeclarationContainerMetadata.functions = kmPackage.getFunctions().stream().map(KotlinMetadataInitializer::convertKmFunction).collect(Collectors.toList());
        kotlinDeclarationContainerMetadata.typeAliases = kmPackage.getTypeAliases().stream().map(KotlinMetadataInitializer::convertKmTypeAlias).collect(Collectors.toList());
        kotlinDeclarationContainerMetadata.properties = kmPackage.getProperties().stream().map(KotlinMetadataInitializer::convertKmProperty).collect(Collectors.toList());
        kotlinDeclarationContainerMetadata.localDelegatedProperties = JvmExtensionsKt.getLocalDelegatedProperties(kmPackage).stream().map(KotlinMetadataInitializer::convertKmProperty).collect(Collectors.toList());
    }

    public static boolean isSupportedMetadataVersion(KotlinMetadataVersion mv) {
        return mv.major == 1 && mv.minor >= 4 || mv.major == 2;
    }

    public static boolean isValidKotlinMetadataAnnotationField(String name) {
        switch (name) {
            case "k": 
            case "bv": 
            case "mv": 
            case "d1": 
            case "d2": 
            case "xi": 
            case "xs": 
            case "pn": {
                return true;
            }
        }
        return false;
    }

    public static KotlinMetadataType metadataTypeOf(String name) {
        switch (name) {
            case "k": {
                return KotlinMetadataType.k;
            }
            case "bv": {
                return KotlinMetadataType.bv;
            }
            case "mv": {
                return KotlinMetadataType.mv;
            }
            case "d1": {
                return KotlinMetadataType.d1;
            }
            case "d2": {
                return KotlinMetadataType.d2;
            }
            case "xi": {
                return KotlinMetadataType.xi;
            }
            case "xs": {
                return KotlinMetadataType.xs;
            }
            case "pn": {
                return KotlinMetadataType.pn;
            }
        }
        throw new IllegalArgumentException("Unknown Kotlin metadata field '" + name + "'");
    }

    private static class SimpleKotlinMetadataSetter
    implements ClassVisitor {
        private final KotlinMetadata kmd;

        SimpleKotlinMetadataSetter(KotlinMetadata kmd) {
            this.kmd = kmd;
        }

        @Override
        public void visitAnyClass(Clazz clazz) {
            throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            programClass.kotlinMetadata = this.kmd;
        }

        @Override
        public void visitLibraryClass(LibraryClass libraryClass) {
            libraryClass.kotlinMetadata = this.kmd;
        }
    }

    private class ArrayElementValueCollector
    implements ElementValueVisitor,
    ConstantVisitor {
        private final KotlinMetadataType arrayType;
        private int index;

        ArrayElementValueCollector(KotlinMetadataType array) {
            this.arrayType = array;
            this.index = 0;
        }

        @Override
        public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
            clazz.constantPoolEntryAccept(constantElementValue.u2constantValueIndex, this);
        }

        @Override
        public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
            if (this.arrayType == KotlinMetadataType.d1) {
                ((KotlinMetadataInitializer)KotlinMetadataInitializer.this).d1[this.index++] = utf8Constant.getString();
            } else if (this.arrayType == KotlinMetadataType.d2) {
                ((KotlinMetadataInitializer)KotlinMetadataInitializer.this).d2[this.index++] = utf8Constant.getString();
            } else {
                throw new UnsupportedOperationException("Cannot store UTF8Constant in int[]");
            }
        }

        @Override
        public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
            switch (this.arrayType) {
                case mv: {
                    ((KotlinMetadataInitializer)KotlinMetadataInitializer.this).mv[this.index++] = integerConstant.getValue();
                    break;
                }
                case bv: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Cannot store IntegerConstant in String[]");
                }
            }
        }
    }
}

