/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.inject.argument;

import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.inject.argument.InjectedArgument;

public class ConstantPrimitive<T extends Number>
implements InjectedArgument {
    private final T numericConstant;

    public ConstantPrimitive(T constant) {
        this.numericConstant = constant;
    }

    @Override
    public Object getValue() {
        return this.numericConstant;
    }

    @Override
    public String getInternalType() {
        switch (this.numericConstant.getClass().getName()) {
            case "java.lang.Boolean": {
                return "Z";
            }
            case "java.lang.Byte": {
                return "B";
            }
            case "java.lang.Character": {
                return "C";
            }
            case "java.lang.Short": {
                return "S";
            }
            case "java.lang.Integer": {
                return "I";
            }
            case "java.lang.Long": {
                return "J";
            }
            case "java.lang.Float": {
                return "F";
            }
            case "java.lang.Double": {
                return "D";
            }
        }
        throw new RuntimeException("Unexpected type");
    }

    public String toString() {
        return this.numericConstant.toString() + ":" + ClassUtil.externalType(this.getInternalType());
    }
}

