/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.visitor;

import java.util.function.Predicate;
import proguard.classfile.Clazz;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.visitor.AllAnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.AnnotationTypeFilter;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.kotlin.KotlinMetadataVersion;
import proguard.classfile.util.kotlin.KotlinMetadataType;
import proguard.classfile.visitor.ClassVisitor;

public class KotlinMetadataVersionFilter
implements ClassVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private final Predicate<KotlinMetadataVersion> predicate;
    private final ClassVisitor accepted;
    private final ClassVisitor rejected;
    private final int[] mv = new int[3];

    public KotlinMetadataVersionFilter(Predicate<KotlinMetadataVersion> predicate, ClassVisitor accepted, ClassVisitor rejected) {
        this.predicate = predicate;
        this.accepted = accepted;
        this.rejected = rejected;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        clazz.accept(new AllAttributeVisitor(new AttributeNameFilter("RuntimeVisibleAnnotations", (AttributeVisitor)new AllAnnotationVisitor(new AnnotationTypeFilter("Lkotlin/Metadata;", (AnnotationVisitor)this)))));
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.elementValuesAccept(clazz, this);
        if (this.predicate.test(new KotlinMetadataVersion(this.mv))) {
            clazz.accept(this.accepted);
        } else {
            clazz.accept(this.rejected);
        }
    }

    @Override
    public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        KotlinMetadataType arrayElementType = KotlinMetadataType.valueOf(arrayElementValue.getMethodName(clazz));
        arrayElementValue.elementValuesAccept(clazz, annotation, new MetadataVersionCollector(arrayElementType));
    }

    private class MetadataVersionCollector
    implements ElementValueVisitor,
    ConstantVisitor {
        private int index = 0;
        private final KotlinMetadataType arrayElementType;

        public MetadataVersionCollector(KotlinMetadataType arrayElementType) {
            this.arrayElementType = arrayElementType;
        }

        @Override
        public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        }

        @Override
        public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
            clazz.constantPoolEntryAccept(constantElementValue.u2constantValueIndex, this);
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
            if (this.arrayElementType == KotlinMetadataType.mv) {
                ((KotlinMetadataVersionFilter)KotlinMetadataVersionFilter.this).mv[this.index++] = integerConstant.getValue();
            }
        }
    }
}

