/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExtendedLineNumberInfo;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.MemberAdder;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.util.StringFunction;

public class MethodCopier
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private final ProgramClass sourceClass;
    private final ProgramMethod sourceMethod;
    private final StringFunction nameTransformer;
    private final MemberVisitor extraMemberVisitor;

    public MethodCopier(ProgramClass sourceClass, ProgramMethod sourceMethod) {
        this(sourceClass, sourceMethod, null);
    }

    public MethodCopier(ProgramClass sourceClass, ProgramMethod sourceMethod, StringFunction nameTransformer) {
        this(sourceClass, sourceMethod, nameTransformer, null);
    }

    public MethodCopier(ProgramClass sourceClass, ProgramMethod sourceMethod, StringFunction nameTransformer, MemberVisitor extraMemberVisitor) {
        this.sourceClass = sourceClass;
        this.sourceMethod = sourceMethod;
        this.nameTransformer = nameTransformer;
        this.extraMemberVisitor = extraMemberVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (this.methodAlreadyExistsInClass(programClass)) {
            return;
        }
        MemberVisitor copiedMethodVisitor = this.extraMemberVisitor == null ? this : new MultiMemberVisitor(this, this.extraMemberVisitor);
        new MemberAdder(programClass, this.nameTransformer, copiedMethodVisitor).visitProgramMethod(this.sourceClass, this.sourceMethod);
    }

    private boolean methodAlreadyExistsInClass(ProgramClass programClass) {
        String sourceMethodName = this.sourceMethod.getName(this.sourceClass);
        String sourceMethodDescriptor = this.sourceMethod.getDescriptor(this.sourceClass);
        String toCheckName = this.nameTransformer == null ? sourceMethodName : this.nameTransformer.transform(sourceMethodName);
        return programClass.findMethod(toCheckName, sourceMethodDescriptor) != null;
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.accept(programClass, (MemberVisitor)new AllAttributeVisitor(new AttributeNameFilter("Code", (AttributeVisitor)this)));
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        LineNumberTableAttribute copiedMethodLineNumberTableAttribute = (LineNumberTableAttribute)codeAttribute.getAttribute(clazz, "LineNumberTable");
        if (copiedMethodLineNumberTableAttribute == null || copiedMethodLineNumberTableAttribute.u2lineNumberTableLength == 0) {
            return;
        }
        this.sourceMethod.accept(this.sourceClass, (MemberVisitor)new AllAttributeVisitor(new AttributeNameFilter("Code", (AttributeVisitor)new MyLineFixer(copiedMethodLineNumberTableAttribute))));
    }

    private static class MyLineFixer
    implements AttributeVisitor {
        private final LineNumberTableAttribute copiedMethodLineNumberTableAttribute;

        MyLineFixer(LineNumberTableAttribute copiedMethodLineNumberTableAttribute) {
            this.copiedMethodLineNumberTableAttribute = copiedMethodLineNumberTableAttribute;
        }

        @Override
        public void visitCodeAttribute(Clazz sourceClass, Method sourceMethod, CodeAttribute sourceMethodCodeAttribute) {
            LineNumberTableAttribute sourceMethodLineNumberTableAttribute = (LineNumberTableAttribute)sourceMethodCodeAttribute.getAttribute(sourceClass, "LineNumberTable");
            int lowestLineNumber = sourceMethodLineNumberTableAttribute == null ? 0 : sourceMethodLineNumberTableAttribute.getLowestLineNumber();
            int highestLineNumber = sourceMethodLineNumberTableAttribute == null ? 0 : sourceMethodLineNumberTableAttribute.getHighestLineNumber();
            String newSource = this.initializeLineNumberInfoSource(sourceClass, sourceMethod, lowestLineNumber, highestLineNumber);
            for (int i = 0; i < this.copiedMethodLineNumberTableAttribute.u2lineNumberTableLength; ++i) {
                LineNumberInfo currentLineNumberInfo = this.copiedMethodLineNumberTableAttribute.lineNumberTable[i];
                ExtendedLineNumberInfo newLineNumberInfo = new ExtendedLineNumberInfo(currentLineNumberInfo.u2startPC, currentLineNumberInfo.u2lineNumber, newSource);
                this.copiedMethodLineNumberTableAttribute.lineNumberTable[i] = newLineNumberInfo;
            }
        }

        private String initializeLineNumberInfoSource(Clazz sourceClass, Method sourceMethod, int startLineNumber, int endLineNumber) {
            return sourceClass.getName() + "." + sourceMethod.getName(sourceClass) + sourceMethod.getDescriptor(sourceClass) + ":" + startLineNumber + ":" + endLineNumber;
        }
    }
}

