/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;

public class MethodDescriptor {
    private static final Map<String, WeakReference<String>> typeCache = new WeakHashMap<String, WeakReference<String>>();
    @Deprecated
    public final String returnType;
    @Deprecated
    public final List<String> argumentTypes;
    private final int hash;

    public MethodDescriptor(String descriptor) {
        if (descriptor == null) {
            this.returnType = null;
            this.argumentTypes = null;
            this.hash = 0;
        } else {
            this.returnType = MethodDescriptor.intern(ClassUtil.internalMethodReturnType(descriptor));
            int count = ClassUtil.internalMethodParameterCount(descriptor);
            if (count == 0) {
                this.argumentTypes = Collections.emptyList();
            } else {
                String[] argumentTypes = new String[count];
                InternalTypeEnumeration typeEnum = new InternalTypeEnumeration(descriptor);
                for (int i = 0; i < count; ++i) {
                    argumentTypes[i] = MethodDescriptor.intern(typeEnum.nextType());
                }
                this.argumentTypes = Arrays.asList(argumentTypes);
            }
            this.hash = Objects.hash(this.returnType, this.argumentTypes);
        }
    }

    public MethodDescriptor(String returnType, List<String> argumentTypes) {
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
        this.hash = Objects.hash(returnType, argumentTypes);
    }

    public boolean isIncomplete() {
        return this.returnType == null || this.argumentTypes == null;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public List<String> getArgumentTypes() {
        return this.argumentTypes;
    }

    public static boolean matchesIgnoreNull(MethodDescriptor descriptor, MethodDescriptor wildcard) {
        if (wildcard == null) {
            return true;
        }
        if (descriptor == null) {
            return false;
        }
        return !(wildcard.returnType != null && !Objects.equals(descriptor.returnType, wildcard.returnType) || wildcard.argumentTypes != null && !Objects.equals(descriptor.argumentTypes, wildcard.argumentTypes));
    }

    public static boolean matchesIgnoreNullAndDollar(MethodDescriptor descriptor, MethodDescriptor wildcard) {
        if (wildcard == null) {
            return true;
        }
        if (descriptor == null) {
            return false;
        }
        return MethodDescriptor.checkReturnType(descriptor.returnType, wildcard.returnType) && MethodDescriptor.checkArguments(wildcard.argumentTypes, descriptor.argumentTypes);
    }

    private static boolean checkReturnType(String returnType, String wildcardReturnType) {
        if (wildcardReturnType == null) {
            return true;
        }
        if (returnType == null) {
            return false;
        }
        return Objects.equals(MethodDescriptor.replaceDollar(returnType), MethodDescriptor.replaceDollar(wildcardReturnType));
    }

    private static boolean checkArguments(List<String> wildcardArgumentTypes, List<String> argumentTypes) {
        if (wildcardArgumentTypes == null) {
            return true;
        }
        if (argumentTypes == null) {
            return false;
        }
        if (wildcardArgumentTypes.size() != argumentTypes.size()) {
            return false;
        }
        return Objects.equals(argumentTypes.stream().map(MethodDescriptor::replaceDollar).collect(Collectors.toList()), wildcardArgumentTypes.stream().map(MethodDescriptor::replaceDollar).collect(Collectors.toList()));
    }

    private static String replaceDollar(String s) {
        return ClassUtil.isInternalClassType(s) ? s.replace('$', '/') : s;
    }

    public String getPrettyReturnType() {
        if (this.returnType != null) {
            return ClassUtil.externalShortClassName(ClassUtil.externalType(this.returnType));
        }
        return "?";
    }

    public String getPrettyArgumentTypes() {
        if (this.argumentTypes != null) {
            return this.argumentTypes.stream().map(ClassUtil::externalType).map(ClassUtil::externalShortClassName).collect(Collectors.joining(","));
        }
        return "?";
    }

    public String toString() {
        if (this.returnType != null) {
            if (this.argumentTypes != null) {
                return ClassUtil.internalMethodDescriptorFromInternalTypes(this.returnType, this.argumentTypes);
            }
            return "(?)" + this.returnType;
        }
        if (this.argumentTypes != null) {
            return ClassUtil.internalMethodDescriptorFromInternalTypes("?", this.argumentTypes);
        }
        return "(?)?";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDescriptor that = (MethodDescriptor)o;
        return Objects.equals(this.returnType, that.returnType) && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    public int hashCode() {
        return this.hash;
    }

    private static synchronized String intern(String item) {
        String oldItem;
        WeakReference<String> ref = typeCache.get(item);
        if (ref != null && (oldItem = (String)ref.get()) != null) {
            return oldItem;
        }
        typeCache.put(item, new WeakReference<String>(item));
        return item;
    }
}

