/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.datastructure.callgraph;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import proguard.analysis.datastructure.CodeLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.Signature;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.Value;

public class ConcreteCall
extends Call {
    private final Clazz targetClass;
    private final Method target;

    public ConcreteCall(CodeLocation caller, Clazz targetClass, Method target, Value instance, List<Value> arguments, Value returnValue, int throwsNullptr, Instruction instruction, boolean controlFlowDependent, boolean runtimeTypeDependent) {
        super(caller, instance, arguments, returnValue, throwsNullptr, instruction, controlFlowDependent, runtimeTypeDependent);
        this.targetClass = targetClass;
        this.target = target;
    }

    public ConcreteCall(CodeLocation caller, Clazz targetClass, Method target, int throwsNullptr, Instruction instruction, boolean controlFlowDependent, boolean runtimeTypeDependent) {
        this(caller, targetClass, target, null, Collections.emptyList(), null, throwsNullptr, instruction, controlFlowDependent, runtimeTypeDependent);
    }

    @Override
    public MethodSignature getTarget() {
        return (MethodSignature)Signature.of(this.targetClass, this.target);
    }

    @Override
    public boolean hasIncompleteTarget() {
        return false;
    }

    public Clazz getTargetClass() {
        return this.targetClass;
    }

    public Method getTargetMethod() {
        return this.target;
    }

    @Override
    public void targetMethodAccept(MemberVisitor memberVisitor) {
        if (this.targetClass != null && this.target != null) {
            this.target.accept(this.targetClass, memberVisitor);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConcreteCall that = (ConcreteCall)o;
        return Objects.equals(this.targetClass, that.targetClass) && Objects.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetClass, this.target);
    }
}

