/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.memory;

import java.util.Objects;
import java.util.Optional;
import proguard.analysis.cpa.bam.BamLocationDependent;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;

public class BamLocationDependentJvmMemoryLocation<ContentT extends AbstractState<ContentT>>
implements ProgramLocationDependent,
BamLocationDependent<ContentT> {
    private final JvmMemoryLocation memoryLocation;
    private JvmCfaNode programLocation;
    private ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> sourceReachedSet;

    public BamLocationDependentJvmMemoryLocation(JvmMemoryLocation memoryLocation) {
        this(memoryLocation, null, null);
    }

    public BamLocationDependentJvmMemoryLocation(JvmMemoryLocation memoryLocation, JvmCfaNode programLocation, ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> sourceReachedSet) {
        this.memoryLocation = memoryLocation;
        this.programLocation = programLocation;
        this.sourceReachedSet = sourceReachedSet;
    }

    public JvmMemoryLocation getMemoryLocation() {
        return this.memoryLocation;
    }

    public BamLocationDependentJvmMemoryLocation<ContentT> copy() {
        return new BamLocationDependentJvmMemoryLocation<ContentT>(this.memoryLocation, this.programLocation, this.sourceReachedSet);
    }

    public ContentT extractFirstValue(ContentT defaultValue) {
        Optional<JvmAbstractState<ContentT>> firstReachedState = this.sourceReachedSet.getReached(this.programLocation).stream().findFirst();
        if (!firstReachedState.isPresent()) {
            return defaultValue;
        }
        return this.memoryLocation.extractValueOrDefault(firstReachedState.get(), defaultValue);
    }

    @Override
    public JvmCfaNode getProgramLocation() {
        return this.programLocation;
    }

    @Override
    public void setProgramLocation(JvmCfaNode programLocation) {
        this.programLocation = programLocation;
    }

    @Override
    public ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> getSourceReachedSet() {
        return this.sourceReachedSet;
    }

    @Override
    public void setSourceReachedSet(ProgramLocationDependentReachedSet<JvmAbstractState<ContentT>> sourceReachedSet) {
        this.sourceReachedSet = sourceReachedSet;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BamLocationDependentJvmMemoryLocation)) {
            return false;
        }
        BamLocationDependentJvmMemoryLocation other = (BamLocationDependentJvmMemoryLocation)obj;
        return Objects.equals(this.sourceReachedSet, other.sourceReachedSet) && this.programLocation == other.programLocation && Objects.equals(this.memoryLocation, other.memoryLocation);
    }

    public int hashCode() {
        return Objects.hash(this.memoryLocation, this.programLocation, this.sourceReachedSet);
    }

    public String toString() {
        return this.memoryLocation.toString() + (this.programLocation == null ? "" : "@" + this.programLocation.getSignature().getFqn() + ":" + this.programLocation.getOffset());
    }
}

