/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.AfterInitConfigurationVerifier;
import proguard.AppView;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.ConfigurationVerifier;
import proguard.ConfigurationWriter;
import proguard.Dumper;
import proguard.GPL;
import proguard.Initializer;
import proguard.InputReader;
import proguard.KotlinMetadataAdapter;
import proguard.OutputWriter;
import proguard.SeedPrinter;
import proguard.Targeter;
import proguard.UpToDateChecker;
import proguard.backport.Backporter;
import proguard.classfile.editor.ClassElementSorter;
import proguard.classfile.pass.PrimitiveArrayConstantIntroducer;
import proguard.classfile.util.PrimitiveArrayConstantReplacer;
import proguard.configuration.ConfigurationLoggingAdder;
import proguard.configuration.InitialStateInfo;
import proguard.evaluation.IncompleteClassHierarchyException;
import proguard.logging.Logging;
import proguard.mark.Marker;
import proguard.normalize.StringNormalizer;
import proguard.obfuscate.NameObfuscationReferenceFixer;
import proguard.obfuscate.ObfuscationPreparation;
import proguard.obfuscate.Obfuscator;
import proguard.obfuscate.ResourceFileNameAdapter;
import proguard.optimize.LineNumberTrimmer;
import proguard.optimize.Optimizer;
import proguard.optimize.gson.GsonOptimizer;
import proguard.optimize.peephole.LineNumberLinearizer;
import proguard.pass.PassRunner;
import proguard.preverify.PreverificationClearer;
import proguard.preverify.Preverifier;
import proguard.preverify.SubroutineInliner;
import proguard.shrink.Shrinker;
import proguard.strip.KotlinAnnotationStripper;
import proguard.util.ConstantMatcher;
import proguard.util.ListParser;
import proguard.util.NameParser;
import proguard.util.StringMatcher;
import proguard.util.kotlin.KotlinUnsupportedVersionChecker;
import proguard.util.kotlin.asserter.KotlinMetadataVerifier;

public class ProGuard {
    private static final Logger logger = LogManager.getLogger(ProGuard.class);
    public static final String VERSION = "ProGuard, version " + ProGuard.getVersion();
    private final AppView appView = new AppView();
    private final PassRunner passRunner = new PassRunner();
    private final Configuration configuration;

    public ProGuard(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute() throws Exception {
        Logging.configureVerbosity(this.configuration.verbose);
        logger.always().log(VERSION);
        try {
            ConstantMatcher filter;
            this.checkGpl();
            if (!this.configuration.dontProcessKotlinMetadata) {
                this.configuration.keepKotlinMetadata = this.requiresKotlinMetadata();
            }
            if (this.configuration.printConfiguration != null) {
                this.printConfiguration();
            }
            this.checkConfiguration();
            if (this.configuration.programJars.hasOutput()) {
                this.checkUpToDate();
            }
            if (this.configuration.targetClassVersion != 0) {
                this.configuration.backport = true;
            }
            this.readInput();
            if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify) {
                this.clearPreverification();
            }
            if (this.configuration.printSeeds != null || this.configuration.backport || this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify || this.configuration.addConfigurationDebugging || this.configuration.keepKotlinMetadata) {
                this.initialize();
                this.mark();
            }
            this.checkConfigurationAfterInitialization();
            if (this.configuration.addConfigurationDebugging) {
                this.appView.initialStateInfo = new InitialStateInfo(this.appView.programClassPool);
            }
            if (this.configuration.keepKotlinMetadata) {
                this.stripKotlinMetadataAnnotations();
            }
            if (this.configuration.optimize || this.configuration.obfuscate) {
                this.introducePrimitiveArrayConstants();
            }
            if (this.configuration.backport) {
                this.backport();
            }
            if (this.configuration.addConfigurationDebugging) {
                this.addConfigurationLogging();
            }
            if (this.configuration.printSeeds != null) {
                this.printSeeds();
            }
            if (this.configuration.preverify || this.configuration.android) {
                this.inlineSubroutines();
            }
            if (this.configuration.shrink) {
                this.shrink(false);
            }
            StringMatcher stringMatcher = filter = this.configuration.optimizations != null ? new ListParser(new NameParser()).parse(this.configuration.optimizations) : new ConstantMatcher(true);
            if (this.configuration.optimize && filter.matches("library/gson")) {
                this.optimizeGson();
            }
            if (this.configuration.optimize) {
                this.optimize();
                this.linearizeLineNumbers();
            }
            if (this.configuration.obfuscate) {
                this.obfuscate();
            }
            if (this.configuration.keepKotlinMetadata) {
                this.adaptKotlinMetadata();
            }
            if (this.configuration.optimize || this.configuration.obfuscate) {
                this.expandPrimitiveArrayConstants();
                this.normalizeStrings();
            }
            if (this.configuration.targetClassVersion != 0) {
                this.target();
            }
            if (this.configuration.preverify) {
                this.preverify();
            }
            if (this.configuration.optimize || this.configuration.preverify) {
                this.trimLineNumbers();
            }
            if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify) {
                this.sortClassElements();
            }
            if (this.configuration.programJars.hasOutput()) {
                this.writeOutput();
            }
            if (this.configuration.dump != null) {
                this.dump();
            }
        }
        catch (UpToDateChecker.UpToDateException filter) {
        }
        catch (IncompleteClassHierarchyException e) {
            throw new RuntimeException(System.lineSeparator() + System.lineSeparator() + "It appears you are missing some classes resulting in an incomplete class hierarchy, " + System.lineSeparator() + "please refer to the troubleshooting page in the manual: " + System.lineSeparator() + "https://www.guardsquare.com/en/products/proguard/manual/troubleshooting#superclass" + System.lineSeparator());
        }
    }

    private void normalizeStrings() throws Exception {
        this.passRunner.run(new StringNormalizer(), this.appView);
    }

    private void checkGpl() {
        GPL.check();
    }

    private boolean requiresKotlinMetadata() {
        return this.configuration.keepKotlinMetadata || this.configuration.keep != null && this.configuration.keep.stream().anyMatch(keepClassSpecification -> !keepClassSpecification.allowObfuscation && !keepClassSpecification.allowShrinking && "kotlin/Metadata".equals(keepClassSpecification.className));
    }

    private void printConfiguration() throws IOException {
        try (ConfigurationWriter configurationWriter = new ConfigurationWriter(this.configuration.printConfiguration);){
            configurationWriter.write(this.configuration);
        }
    }

    private void checkConfiguration() throws IOException {
        new ConfigurationVerifier(this.configuration).check();
    }

    private void checkUpToDate() {
        new UpToDateChecker(this.configuration).check();
    }

    private void readInput() throws Exception {
        this.passRunner.run(new InputReader(this.configuration), this.appView);
    }

    private void clearPreverification() throws Exception {
        this.passRunner.run(new PreverificationClearer(), this.appView);
    }

    private void initialize() throws Exception {
        if (this.configuration.keepKotlinMetadata) {
            this.passRunner.run(new KotlinUnsupportedVersionChecker(), this.appView);
        }
        this.passRunner.run(new Initializer(this.configuration), this.appView);
        this.verifyKotlinMetadata();
    }

    private void mark() throws Exception {
        this.passRunner.run(new Marker(this.configuration), this.appView);
    }

    private void stripKotlinMetadataAnnotations() throws Exception {
        this.passRunner.run(new KotlinAnnotationStripper(this.configuration), this.appView);
    }

    private void checkConfigurationAfterInitialization() throws Exception {
        this.passRunner.run(new AfterInitConfigurationVerifier(this.configuration), this.appView);
    }

    private void introducePrimitiveArrayConstants() throws Exception {
        this.passRunner.run(new PrimitiveArrayConstantIntroducer(), this.appView);
    }

    private void backport() throws Exception {
        this.passRunner.run(new Backporter(this.configuration), this.appView);
    }

    private void addConfigurationLogging() throws Exception {
        this.passRunner.run(new ConfigurationLoggingAdder(), this.appView);
    }

    private void printSeeds() throws Exception {
        this.passRunner.run(new SeedPrinter(this.configuration), this.appView);
    }

    private void inlineSubroutines() throws Exception {
        this.passRunner.run(new SubroutineInliner(this.configuration), this.appView);
    }

    private void shrink(boolean afterOptimizer) throws Exception {
        this.passRunner.run(new Shrinker(this.configuration, afterOptimizer), this.appView);
        this.verifyKotlinMetadata();
    }

    private void optimizeGson() throws Exception {
        this.passRunner.run(new GsonOptimizer(this.configuration), this.appView);
    }

    private void optimize() throws Exception {
        Optimizer optimizer = new Optimizer(this.configuration);
        for (int optimizationPass = 0; optimizationPass < this.configuration.optimizationPasses; ++optimizationPass) {
            this.passRunner.run(optimizer, this.appView);
            if (!this.configuration.shrink) continue;
            this.shrink(true);
        }
    }

    private void linearizeLineNumbers() throws Exception {
        this.passRunner.run(new LineNumberLinearizer(), this.appView);
    }

    private void obfuscate() throws Exception {
        this.passRunner.run(new ObfuscationPreparation(this.configuration), this.appView);
        this.passRunner.run(new Obfuscator(this.configuration), this.appView);
        if (this.configuration.adaptResourceFileNames != null) {
            this.passRunner.run(new ResourceFileNameAdapter(this.configuration), this.appView);
        }
        this.passRunner.run(new NameObfuscationReferenceFixer(this.configuration), this.appView);
        this.verifyKotlinMetadata();
    }

    private void adaptKotlinMetadata() throws Exception {
        this.passRunner.run(new KotlinMetadataAdapter(), this.appView);
    }

    private void verifyKotlinMetadata() throws Exception {
        if (this.configuration.keepKotlinMetadata && this.configuration.enableKotlinAsserter) {
            this.passRunner.run(new KotlinMetadataVerifier(this.configuration), this.appView);
        }
    }

    private void expandPrimitiveArrayConstants() {
        this.appView.programClassPool.classesAccept(new PrimitiveArrayConstantReplacer());
    }

    private void target() throws Exception {
        this.passRunner.run(new Targeter(this.configuration), this.appView);
    }

    private void preverify() throws Exception {
        this.passRunner.run(new Preverifier(this.configuration), this.appView);
    }

    private void trimLineNumbers() throws Exception {
        this.passRunner.run(new LineNumberTrimmer(), this.appView);
    }

    private void sortClassElements() {
        this.appView.programClassPool.classesAccept(new ClassElementSorter(true, true, false, false));
    }

    private void writeOutput() throws Exception {
        this.passRunner.run(new OutputWriter(this.configuration), this.appView);
    }

    private void dump() throws Exception {
        this.passRunner.run(new Dumper(this.configuration), this.appView);
    }

    public static String getVersion() {
        String version;
        Package pack = ProGuard.class.getPackage();
        if (pack != null && (version = pack.getImplementationVersion()) != null) {
            return version;
        }
        return "undefined";
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            logger.warn(VERSION);
            logger.warn("Usage: java proguard.ProGuard [options ...]");
            System.exit(1);
        }
        Configuration configuration = new Configuration();
        try {
            try (ConfigurationParser parser = new ConfigurationParser(args, System.getProperties());){
                parser.parse(configuration);
            }
            new ProGuard(configuration).execute();
        }
        catch (Exception ex) {
            logger.error("Unexpected error", (Throwable)ex);
            System.exit(1);
        }
        System.exit(0);
    }
}

